/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.processors;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opendataloader.pdf.processors.DocumentProcessor;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class TextProcessor {
    private static final double MIN_TEXT_INTERSECTION_PERCENT = 0.5;
    private static final double MAX_TOP_DECORATION_IMAGE_EPSILON = 0.3;
    private static final double MAX_BOTTOM_DECORATION_IMAGE_EPSILON = 0.1;
    private static final double MAX_LEFT_DECORATION_IMAGE_EPSILON = 0.1;
    private static final double MAX_RIGHT_DECORATION_IMAGE_EPSILON = 1.5;
    private static final double TEXT_MIN_HEIGHT = 1.0;

    public static void replaceUndefinedCharacters(List<IObject> contents, String replacementCharacterString) {
        if ("\ufffd".equals(replacementCharacterString)) {
            return;
        }
        for (IObject object : contents) {
            TextChunk textChunk;
            if (!(object instanceof TextChunk) || !(textChunk = (TextChunk)object).getValue().contains("\ufffd")) continue;
            textChunk.setValue(textChunk.getValue().replaceAll("\ufffd", replacementCharacterString));
        }
    }

    public static void filterTinyText(List<IObject> contents) {
        for (int i = 0; i < contents.size(); ++i) {
            TextChunk textChunk;
            IObject object = contents.get(i);
            if (!(object instanceof TextChunk) || !((textChunk = (TextChunk)object).getBoundingBox().getHeight() <= 1.0)) continue;
            contents.set(i, null);
        }
    }

    public static void trimTextChunksWhiteSpaces(List<IObject> contents) {
        for (int i = 0; i < contents.size(); ++i) {
            IObject object = contents.get(i);
            if (!(object instanceof TextChunk)) continue;
            contents.set(i, ChunksMergeUtils.getTrimTextChunk((TextChunk)object));
        }
    }

    public static void removeSameTextChunks(List<IObject> contents) {
        DocumentProcessor.setIndexesForContentsList(contents);
        List sortedTextChunks = contents.stream().filter(c -> c instanceof TextChunk).sorted(Comparator.comparing(x -> ((TextChunk)x).getValue())).collect(Collectors.toList());
        TextChunk lastTextChunk = null;
        for (IObject object : sortedTextChunks) {
            if (!(object instanceof TextChunk)) continue;
            TextChunk currentTextChunk = (TextChunk)object;
            if (lastTextChunk != null && TextProcessor.areSameTextChunks(lastTextChunk, currentTextChunk)) {
                contents.set(lastTextChunk.getIndex(), null);
            }
            lastTextChunk = currentTextChunk;
        }
    }

    public static boolean areSameTextChunks(TextChunk firstTextChunk, TextChunk secondTextChunk) {
        return Objects.equals(firstTextChunk.getValue(), secondTextChunk.getValue()) && NodeUtils.areCloseNumbers(firstTextChunk.getWidth(), secondTextChunk.getWidth()) && NodeUtils.areCloseNumbers(firstTextChunk.getHeight(), secondTextChunk.getHeight()) && firstTextChunk.getBoundingBox().getIntersectionPercent(secondTextChunk.getBoundingBox()) > 0.5;
    }

    public static void removeTextDecorationImages(List<IObject> contents) {
        TextChunk lastTextChunk = null;
        for (int index = 0; index < contents.size(); ++index) {
            IObject object = contents.get(index);
            if (object instanceof TextChunk) {
                lastTextChunk = (TextChunk)object;
                continue;
            }
            if (!(object instanceof ImageChunk) || lastTextChunk == null || !TextProcessor.isTextChunkDecorationImage((ImageChunk)object, lastTextChunk)) continue;
            contents.set(index, null);
        }
    }

    public static boolean isTextChunkDecorationImage(ImageChunk imageChunk, TextChunk textChunk) {
        return NodeUtils.areCloseNumbers(imageChunk.getTopY(), textChunk.getTopY(), 0.3 * textChunk.getHeight()) && NodeUtils.areCloseNumbers(imageChunk.getBottomY(), textChunk.getBottomY(), 0.1 * textChunk.getHeight()) && (NodeUtils.areCloseNumbers(imageChunk.getLeftX(), textChunk.getLeftX(), 0.1 * textChunk.getHeight()) || imageChunk.getLeftX() > textChunk.getLeftX()) && (NodeUtils.areCloseNumbers(imageChunk.getRightX(), textChunk.getRightX(), 1.5 * textChunk.getHeight()) || imageChunk.getRightX() < textChunk.getRightX());
    }
}

