/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModeWeightStatistics {
    private final double scoreMax;
    private final double scoreMin;
    private final double modeMin;
    private final double modeMax;
    private final Map<Double, Long> countMap = new HashMap<Double, Long>();
    private List<Map.Entry<Double, Long>> sorted = new ArrayList<Map.Entry<Double, Long>>();
    private List<Double> higherScores = new ArrayList<Double>();
    private boolean isInitHigherScores = false;

    public ModeWeightStatistics(double scoreMin, double scoreMax, double modeMin, double modeMax) {
        this.scoreMin = scoreMin;
        this.scoreMax = scoreMax;
        this.modeMin = modeMin;
        this.modeMax = modeMax;
    }

    public void addScore(double score) {
        this.countMap.merge(score, 1L, Long::sum);
    }

    public double getBoost(double score) {
        this.initHigherScores();
        int n = this.higherScores.size();
        if (n == 0) {
            return 0.0;
        }
        for (int i = 0; i < n; ++i) {
            if (Double.compare(this.higherScores.get(i), score) != 0) continue;
            return (double)(i + 1) / (double)n;
        }
        return 0.0;
    }

    public void sortByFrequency() {
        this.sorted = new ArrayList<Map.Entry<Double, Long>>(this.countMap.entrySet());
        this.sorted.sort((a, b) -> Long.compare((Long)b.getValue(), (Long)a.getValue()));
    }

    public double getMode() {
        for (Map.Entry<Double, Long> entry : this.sorted) {
            double value = entry.getKey();
            if (!(value >= this.modeMin) || !(value <= this.modeMax)) continue;
            return value;
        }
        return 0.0;
    }

    private void initHigherScores() {
        if (this.isInitHigherScores) {
            return;
        }
        this.sortByFrequency();
        double mode = this.getMode();
        this.higherScores = this.sorted.stream().map(Map.Entry::getKey).filter(s -> s > mode && s >= this.scoreMin && s <= this.scoreMax).sorted().collect(Collectors.toList());
        this.isInitHigherScores = true;
    }
}

