/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.utils.levels;

import java.util.Objects;
import org.opendataloader.pdf.utils.levels.LineArtBulletParagraphLevelInfo;
import org.opendataloader.pdf.utils.levels.ListLevelInfo;
import org.opendataloader.pdf.utils.levels.TextBulletParagraphLevelInfo;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class LevelInfo {
    protected static final double X_GAP_MULTIPLIER = 0.3;
    private final double left;
    private final double right;

    public LevelInfo(double left, double right) {
        this.left = left;
        this.right = right;
    }

    public static boolean areSameLevelsInfos(LevelInfo levelInfo1, LevelInfo levelInfo2) {
        if (levelInfo1.isTable() || levelInfo2.isTable()) {
            return false;
        }
        boolean checkBoundingBox = false;
        if (levelInfo1.isList() && levelInfo2.isList()) {
            ListLevelInfo listLevelInfo1 = (ListLevelInfo)levelInfo1;
            ListLevelInfo listLevelInfo2 = (ListLevelInfo)levelInfo2;
            if (Objects.equals(listLevelInfo1.getNumberingStyle(), listLevelInfo2.getNumberingStyle()) && Objects.equals(listLevelInfo1.getCommonPrefix(), listLevelInfo2.getCommonPrefix())) {
                checkBoundingBox = true;
            }
        } else if (levelInfo1.isTextBulletParagraph() && levelInfo2.isTextBulletParagraph()) {
            TextBulletParagraphLevelInfo textBulletParagraphLevelInfo1 = (TextBulletParagraphLevelInfo)levelInfo1;
            TextBulletParagraphLevelInfo textBulletParagraphLevelInfo2 = (TextBulletParagraphLevelInfo)levelInfo2;
            if (Objects.equals(textBulletParagraphLevelInfo1.getLabel(), textBulletParagraphLevelInfo2.getLabel())) {
                checkBoundingBox = true;
            }
            if (textBulletParagraphLevelInfo1.getLabelRegex() != null && Objects.equals(textBulletParagraphLevelInfo1.getLabelRegex(), textBulletParagraphLevelInfo2.getLabelRegex())) {
                if (Objects.equals(textBulletParagraphLevelInfo1.getLabelRegex(), "^(\uc81c\\d+[\uc7a5\uc870\uc808]).*")) {
                    return true;
                }
                checkBoundingBox = true;
            }
        } else if (levelInfo1.isLineArtBulletParagraph() && levelInfo2.isLineArtBulletParagraph()) {
            LineArtChunk bullet2;
            LineArtBulletParagraphLevelInfo lineArtBulletParagraphLevelInfo1 = (LineArtBulletParagraphLevelInfo)levelInfo1;
            LineArtBulletParagraphLevelInfo lineArtBulletParagraphLevelInfo2 = (LineArtBulletParagraphLevelInfo)levelInfo2;
            LineArtChunk bullet1 = lineArtBulletParagraphLevelInfo1.getBullet();
            if (LineArtChunk.areHaveSameSizes(bullet1, bullet2 = lineArtBulletParagraphLevelInfo2.getBullet())) {
                checkBoundingBox = true;
            }
        }
        return checkBoundingBox ? LevelInfo.checkBoundingBoxes(levelInfo1, levelInfo2) : false;
    }

    public static boolean checkBoundingBoxes(LevelInfo levelInfo1, LevelInfo levelInfo2) {
        return levelInfo1.right < levelInfo2.left || levelInfo2.right < levelInfo1.left || NodeUtils.areCloseNumbers(levelInfo1.left, levelInfo2.left, LevelInfo.getMaxXGap(levelInfo1, levelInfo2)) || NodeUtils.areCloseNumbers(levelInfo1.right, levelInfo2.right, LevelInfo.getMaxXGap(levelInfo1, levelInfo2));
    }

    public boolean isTable() {
        return false;
    }

    public boolean isList() {
        return false;
    }

    public boolean isLineArtBulletParagraph() {
        return false;
    }

    public boolean isTextBulletParagraph() {
        return false;
    }

    public double getMaxXGap() {
        return 0.0;
    }

    public static double getMaxXGap(LevelInfo levelInfo1, LevelInfo levelInfo2) {
        return Math.max(levelInfo1.getMaxXGap(), levelInfo2.getMaxXGap());
    }
}

