/*
 * Decompiled with CFR 0.152.
 */
package org.opendataloader.pdf.utils.levels;

import org.opendataloader.pdf.utils.BulletedParagraphUtils;
import org.opendataloader.pdf.utils.levels.LevelInfo;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;

public class TextBulletParagraphLevelInfo
extends LevelInfo {
    private final String label;
    private final String labelRegex;
    private final double maxFontSize;

    public TextBulletParagraphLevelInfo(SemanticTextNode semanticTextNode) {
        super(semanticTextNode.getFirstLine().getLeftX(), semanticTextNode.getRightX());
        this.labelRegex = BulletedParagraphUtils.getLabelRegex(semanticTextNode);
        this.label = BulletedParagraphUtils.getLabel(semanticTextNode);
        this.maxFontSize = semanticTextNode.getMaxFontSize();
    }

    @Override
    public boolean isTextBulletParagraph() {
        return true;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelRegex() {
        return this.labelRegex;
    }

    @Override
    public double getMaxXGap() {
        return this.maxFontSize * 0.3;
    }
}

