/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.salayer.SAObject;
import org.verapdf.wcag.algorithms.entities.IObject;

public class GFSAObject
extends GenericModelObject
implements SAObject {
    private final List<Integer> errorCodes = new LinkedList<Integer>();
    private final List<List<Object>> errorArguments = new LinkedList<List<Object>>();
    protected IObject object;

    public GFSAObject(String type) {
        super(type);
    }

    public GFSAObject(IObject object, String type) {
        super(type);
        this.object = object;
    }

    @Override
    public List<String> geterrorCodes() {
        return this.errorCodes.stream().map(Objects::toString).collect(Collectors.toList());
    }

    public List<Integer> getErrorCodes() {
        return this.errorCodes;
    }

    public List<List<Object>> getErrorArguments() {
        return this.errorArguments;
    }

    @Override
    public List<List<String>> geterrorArguments() {
        LinkedList<List<String>> list = new LinkedList<List<String>>();
        for (List<Object> arguments : this.errorArguments) {
            list.add(arguments.stream().map(Object::toString).collect(Collectors.toList()));
        }
        return list;
    }

    @Override
    public String getContext() {
        return this.object.getBoundingBox().getLocation();
    }

    @Override
    public String getstructureID() {
        if (this.object.getRecognizedStructureId() != null) {
            return "id:" + this.object.getRecognizedStructureId();
        }
        return null;
    }

    protected void setObject(IObject object) {
        this.object = object;
    }

    protected IObject getObject() {
        return this.object;
    }
}

