/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.verapdf.gf.model.impl.sa.GFSAPDFDocument;
import org.verapdf.gf.model.impl.sa.GFSAStructTreeRoot;
import org.verapdf.model.salayer.SAStructElem;
import org.verapdf.wcag.algorithms.entities.IPage;

public class DocumentSerializer
extends StdSerializer<GFSAPDFDocument> {
    protected DocumentSerializer(Class<GFSAPDFDocument> t) {
        super(t);
    }

    @Override
    public void serialize(GFSAPDFDocument document, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        GFSAStructTreeRoot root;
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", "PDFDocument");
        jsonGenerator.writeFieldName("children");
        jsonGenerator.writeStartArray();
        if (!document.getStructureTreeRoot().isEmpty() && (root = (GFSAStructTreeRoot)document.getStructureTreeRoot().get(0)).getChildren() != null) {
            for (SAStructElem child : root.getChildren()) {
                jsonGenerator.writeObject(child);
            }
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeFieldName("pages");
        jsonGenerator.writeStartArray();
        if (document.getPages() != null) {
            for (IPage page : document.getPages()) {
                jsonGenerator.writeObject(page);
            }
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }
}

