/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Objects;
import org.verapdf.gf.model.impl.sa.GFSAImageChunk;
import org.verapdf.gf.model.impl.sa.GFSALineArtChunk;
import org.verapdf.gf.model.impl.sa.GFSAStructElem;
import org.verapdf.gf.model.impl.sa.GFSATextChunk;
import org.verapdf.model.baselayer.Object;
import org.verapdf.wcag.algorithms.entities.IAttributesDictionary;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticAnnot;

public class NodeSerializer
extends StdSerializer<GFSAStructElem> {
    protected NodeSerializer(Class<GFSAStructElem> t) {
        super(t);
    }

    @Override
    public void serialize(GFSAStructElem elem, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        String type = elem.getstandardType();
        if (type == null) {
            type = "NonStandard";
        }
        jsonGenerator.writeStringField("type", type);
        jsonGenerator.writeNumberField("objectKeyNumber", elem.getStructElemDictionary().getObject().getKey().getNumber());
        if (Objects.equals(elem.getstandardType(), "TD") || Objects.equals(elem.getstandardType(), "TH")) {
            IAttributesDictionary AttributesDictionary2 = elem.getNode().getAttributesDictionary();
            jsonGenerator.writeFieldName("attributes");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("colSpan", AttributesDictionary2.getColSpan());
            jsonGenerator.writeNumberField("rowSpan", AttributesDictionary2.getRowSpan());
            jsonGenerator.writeEndObject();
        }
        if (!elem.getChildren().isEmpty() || !elem.getNode().getChildren().isEmpty()) {
            jsonGenerator.writeFieldName("children");
            jsonGenerator.writeStartArray();
            for (Object object : elem.getChildren()) {
                if (object instanceof GFSATextChunk) {
                    jsonGenerator.writeObject(((GFSATextChunk)object).getTextChunk());
                    continue;
                }
                if (object instanceof GFSAImageChunk) {
                    jsonGenerator.writeObject(((GFSAImageChunk)object).imageChunk);
                    continue;
                }
                if (object instanceof GFSALineArtChunk) {
                    jsonGenerator.writeObject(((GFSALineArtChunk)object).lineArtChunk);
                    continue;
                }
                jsonGenerator.writeObject(object);
            }
            for (INode iNode : elem.getNode().getChildren()) {
                if (!(iNode instanceof SemanticAnnot)) continue;
                jsonGenerator.writeObject(((SemanticAnnot)iNode).getAnnots().get(0));
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }
}

