/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class XsltTransformer {
    private static final Logger LOGGER = Logger.getLogger(XsltTransformer.class.getCanonicalName());
    private static final TransformerFactory factory = XsltTransformer.getTransformerFactory();

    private XsltTransformer() {
    }

    public static void transform(InputStream source, InputStream xslt, PrintWriter destination, Map<String, String> arguments) throws TransformerException {
        Transformer transformer = factory.newTransformer(new StreamSource(xslt));
        if (arguments != null) {
            for (Map.Entry<String, String> entry : arguments.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
        }
        transformer.transform(new StreamSource(source), new StreamResult(destination));
    }

    private static TransformerFactory getTransformerFactory() {
        TransformerFactory fact = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        try {
            fact.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            fact.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "file");
        }
        catch (TransformerConfigurationException e) {
            LOGGER.log(Level.WARNING, "Unable to secure xsl transformer");
        }
        return fact;
    }
}

