/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;

public class BaseObject
implements IObject {
    private BoundingBox boundingBox;
    private final List<Integer> errorCodes;
    private final List<List<Object>> errorArguments;
    private Long recognizedStructureId = null;
    protected Integer index = null;
    protected String level = null;

    public BaseObject(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        this.errorCodes = new LinkedList<Integer>();
        this.errorArguments = new LinkedList<List<Object>>();
    }

    public BaseObject(BoundingBox boundingBox, List<Integer> errorCodes, List<List<Object>> errorArguments) {
        this.boundingBox = boundingBox;
        this.errorCodes = errorCodes;
        this.errorArguments = errorArguments;
    }

    public BaseObject(BaseObject baseObject) {
        this.boundingBox = baseObject.boundingBox;
        this.errorCodes = baseObject.errorCodes;
        this.errorArguments = baseObject.errorArguments;
        this.recognizedStructureId = baseObject.recognizedStructureId;
        this.index = baseObject.index;
    }

    @Override
    public Integer getPageNumber() {
        return this.boundingBox.getPageNumber();
    }

    @Override
    public void setPageNumber(Integer pageNumber) {
        this.boundingBox.setPageNumber(pageNumber);
    }

    @Override
    public Integer getLastPageNumber() {
        return this.boundingBox.getLastPageNumber();
    }

    @Override
    public void setLastPageNumber(Integer lastPageNumber) {
        this.boundingBox.setLastPageNumber(lastPageNumber);
    }

    @Override
    public double getLeftX() {
        return this.boundingBox.getLeftX();
    }

    @Override
    public double getBottomY() {
        return this.boundingBox.getBottomY();
    }

    @Override
    public double getRightX() {
        return this.boundingBox.getRightX();
    }

    @Override
    public double getTopY() {
        return this.boundingBox.getTopY();
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public void setBoundingBox(BoundingBox bbox) {
        this.boundingBox = bbox instanceof MultiBoundingBox ? new MultiBoundingBox(bbox) : new BoundingBox(bbox);
    }

    @Override
    public List<Integer> getErrorCodes() {
        return this.errorCodes;
    }

    @Override
    public List<List<Object>> getErrorArguments() {
        return this.errorArguments;
    }

    @Override
    public Long getRecognizedStructureId() {
        return this.recognizedStructureId;
    }

    @Override
    public void setRecognizedStructureId(Long id) {
        this.recognizedStructureId = id;
    }

    @Override
    public double getWidth() {
        return this.boundingBox.getWidth();
    }

    @Override
    public double getHeight() {
        return this.boundingBox.getHeight();
    }

    @Override
    public double getCenterX() {
        return this.getBoundingBox().getCenterX();
    }

    @Override
    public double getCenterY() {
        return this.getBoundingBox().getCenterY();
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    public String getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(String level) {
        this.level = level;
    }

    public int hashCode() {
        return Objects.hashCode(this.getBoundingBox());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseObject that = (BaseObject)o;
        return that.getBoundingBox().equals(this.getBoundingBox());
    }
}

