/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.lists;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemInfo;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemTextInfo;

public class ListInterval
implements Comparable {
    private List<Integer> listsIndexes = new ArrayList<Integer>();
    private List<ListItemInfo> listItemsInfos = new ArrayList<ListItemInfo>();
    private String numberingStyle = "unknown style";
    public Integer numberOfColumns;

    public ListInterval() {
    }

    public ListInterval(List<ListItemInfo> listItemsInfos, List<Integer> listsIndexes, Integer numberOfColumns) {
        this.listItemsInfos = listItemsInfos;
        this.listsIndexes = listsIndexes;
        this.numberOfColumns = numberOfColumns;
    }

    public ListInterval(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.listItemsInfos.add(new ListItemInfo(i));
        }
    }

    public String getNumberingStyle() {
        return this.numberingStyle;
    }

    public void setNumberingStyle(String numberingStyle) {
        this.numberingStyle = numberingStyle;
    }

    public int getStart() {
        if (!this.listItemsInfos.isEmpty() && !this.listsIndexes.isEmpty()) {
            return Math.min(this.getListItemsStart(), this.getListsStart());
        }
        if (this.listsIndexes.isEmpty()) {
            return this.getListItemsStart();
        }
        return this.getListsStart();
    }

    public Integer getListItemsStart() {
        return this.listItemsInfos.isEmpty() ? null : Integer.valueOf(this.listItemsInfos.get(0).getIndex());
    }

    public Integer getListsStart() {
        return this.listsIndexes.isEmpty() ? null : this.listsIndexes.get(0);
    }

    public int getEnd() {
        if (!this.listItemsInfos.isEmpty() && !this.listsIndexes.isEmpty()) {
            return Math.max(this.getListItemsEnd(), this.getListsEnd());
        }
        if (this.listsIndexes.isEmpty()) {
            return this.getListItemsEnd();
        }
        return this.getListsEnd();
    }

    public Integer getListItemsEnd() {
        return this.listItemsInfos.isEmpty() ? null : Integer.valueOf(this.listItemsInfos.get(this.listItemsInfos.size() - 1).getIndex());
    }

    public Integer getListsEnd() {
        return this.listsIndexes.isEmpty() ? null : this.listsIndexes.get(this.listsIndexes.size() - 1);
    }

    public List<ListItemInfo> getListItemsInfos() {
        return this.listItemsInfos;
    }

    public ListItemInfo getLastListItemInfo() {
        return this.listItemsInfos.get(this.listItemsInfos.size() - 1);
    }

    public ListItemInfo getPenultListItemInfo() {
        return this.listItemsInfos.get(this.listItemsInfos.size() - 2);
    }

    public ListItemInfo getFirstListItemInfo() {
        return this.listItemsInfos.get(0);
    }

    public ListItemInfo getSecondListItemInfo() {
        return this.listItemsInfos.get(1);
    }

    public List<Integer> getListsIndexes() {
        return this.listsIndexes;
    }

    public Integer getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String getCommonPrefix() {
        ListItemInfo listItemInfo = this.getFirstListItemInfo();
        if (listItemInfo instanceof ListItemTextInfo) {
            return ((ListItemTextInfo)listItemInfo).getPrefix();
        }
        return null;
    }

    public int getNumberOfListItemsAndLists() {
        return this.getNumberOfListItems() + this.getNumberOfLists();
    }

    public int getNumberOfListItems() {
        return this.listItemsInfos.size();
    }

    public int getNumberOfLists() {
        return this.listsIndexes.size();
    }

    public List<Integer> getListsIndexesContainedInListItemsIndexes(List<ListItemInfo> listItemsInfos) {
        int i2;
        if (this.listsIndexes.isEmpty()) {
            return new ArrayList<Integer>();
        }
        int firstIndex = listItemsInfos.get(0).getIndex();
        int lastIndex = listItemsInfos.get(listItemsInfos.size() - 1).getIndex();
        List<Integer> newListIndexes = this.listsIndexes.stream().filter(i -> i > firstIndex && i < lastIndex).collect(Collectors.toList());
        for (i2 = firstIndex - 1; i2 >= this.getListsStart() && this.listsIndexes.contains(i2); --i2) {
            newListIndexes.add(i2);
        }
        for (i2 = lastIndex + 1; i2 <= this.getListsEnd() && this.listsIndexes.contains(i2); ++i2) {
            newListIndexes.add(i2);
        }
        Collections.sort(newListIndexes);
        return newListIndexes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListInterval interval = (ListInterval)o;
        return this.listItemsInfos.equals(interval.listItemsInfos) && this.listsIndexes.equals(interval.listsIndexes);
    }

    public int hashCode() {
        return Objects.hash(this.listItemsInfos, this.listsIndexes);
    }

    public boolean contains(ListInterval second) {
        if (Objects.equals(this.getFirstListItemInfo().getPageNumber(), this.getLastListItemInfo().getPageNumber()) && Objects.equals(second.getFirstListItemInfo().getPageNumber(), second.getLastListItemInfo().getPageNumber()) && Objects.equals(this.getFirstListItemInfo().getPageNumber(), second.getFirstListItemInfo().getPageNumber())) {
            return this.getStart() <= second.getStart() && this.getEnd() >= second.getEnd();
        }
        return false;
    }

    public int compareTo(Object o) {
        ListInterval interval = (ListInterval)o;
        if (!Objects.equals(this.getFirstListItemInfo().getPageNumber(), interval.getFirstListItemInfo().getPageNumber())) {
            return this.getFirstListItemInfo().getPageNumber() - interval.getFirstListItemInfo().getPageNumber();
        }
        return this.getStart() - interval.getStart();
    }
}

