/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.lists;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.lists.ListInterval;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemInfo;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemTextInfo;

public class TextListInterval
implements Comparable {
    private List<ListItemTextInfo> listItemsInfos = new ArrayList<ListItemTextInfo>();
    private String numberingStyle = "unknown style";

    public TextListInterval() {
    }

    public TextListInterval(ListInterval interval) {
        for (ListItemInfo info : interval.getListItemsInfos()) {
            this.getListItemsInfos().add((ListItemTextInfo)info);
        }
    }

    public TextListInterval(List<ListItemTextInfo> listItemsInfos) {
        this.listItemsInfos = listItemsInfos;
    }

    public String getNumberingStyle() {
        return this.numberingStyle;
    }

    public void setNumberingStyle(String numberingStyle) {
        this.numberingStyle = numberingStyle;
    }

    public Integer getListItemsStart() {
        return this.listItemsInfos.isEmpty() ? null : Integer.valueOf(this.listItemsInfos.get(0).getIndex());
    }

    public Integer getListItemsEnd() {
        return this.listItemsInfos.isEmpty() ? null : Integer.valueOf(this.listItemsInfos.get(this.listItemsInfos.size() - 1).getIndex());
    }

    public List<ListItemTextInfo> getListItemsInfos() {
        return this.listItemsInfos;
    }

    public ListItemTextInfo getLastListItemInfo() {
        return this.listItemsInfos.get(this.listItemsInfos.size() - 1);
    }

    public void setLastListItemInfo(ListItemTextInfo listItemTextInfo) {
        this.listItemsInfos.set(this.listItemsInfos.size() - 1, listItemTextInfo);
    }

    public ListItemTextInfo getPenultListItemInfo() {
        return this.listItemsInfos.get(this.listItemsInfos.size() - 2);
    }

    public ListItemTextInfo getFirstListItemInfo() {
        return this.listItemsInfos.get(0);
    }

    public ListItemTextInfo getSecondListItemInfo() {
        return this.listItemsInfos.get(1);
    }

    public String getCommonPrefix() {
        ListItemTextInfo listItemInfo = this.getFirstListItemInfo();
        if (listItemInfo != null) {
            return listItemInfo.getPrefix();
        }
        return null;
    }

    public int getNumberOfListItems() {
        return this.listItemsInfos.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextListInterval interval = (TextListInterval)o;
        return this.listItemsInfos.equals(interval.listItemsInfos);
    }

    public int hashCode() {
        return Objects.hash(this.listItemsInfos);
    }

    public int compareTo(Object o) {
        TextListInterval interval = (TextListInterval)o;
        if (!Objects.equals(this.getFirstListItemInfo().getPageNumber(), interval.getFirstListItemInfo().getPageNumber())) {
            return this.getFirstListItemInfo().getPageNumber() - interval.getFirstListItemInfo().getPageNumber();
        }
        return this.getListItemsEnd() - interval.getListItemsStart();
    }
}

