/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables.tableBorders;

import java.util.LinkedList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.BaseObject;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.IObject;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.geometry.MultiBoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;

public class TableBorderCell
extends BaseObject {
    protected int rowNumber;
    protected int colNumber;
    protected int rowSpan;
    protected int colSpan;
    private final List<TableToken> content;
    private List<IObject> contents;
    private SemanticType semanticType;
    private INode node;

    public TableBorderCell(int rowNumber, int colNumber, int rowSpan, int colSpan, Long id) {
        super(new BoundingBox());
        this.rowNumber = rowNumber;
        this.colNumber = colNumber;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
        this.content = new LinkedList<TableToken>();
        this.contents = new LinkedList<IObject>();
        this.setRecognizedStructureId(id);
    }

    public TableBorderCell(INode node, int rowNumber, int colNumber) {
        super(node.getBoundingBox());
        this.node = node;
        this.rowSpan = (int)node.getAttributesDictionary().getRowSpan();
        this.colSpan = (int)node.getAttributesDictionary().getColSpan();
        this.rowNumber = rowNumber;
        this.colNumber = colNumber;
        this.content = new LinkedList<TableToken>();
        this.contents = new LinkedList<IObject>();
    }

    public void addContent(TableToken token) {
        this.content.add(token);
    }

    public List<TableToken> getContent() {
        return this.content;
    }

    public void addContentObject(IObject object) {
        this.contents.add(object);
    }

    public List<IObject> getContents() {
        return this.contents;
    }

    public void setContents(List<IObject> contents) {
        this.contents = contents;
    }

    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    public INode getNode() {
        return this.node;
    }

    public void setNode(INode node) {
        this.node = node;
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public BoundingBox getContentBoundingBox() {
        MultiBoundingBox boundingBox = new MultiBoundingBox();
        for (TableToken token : this.content) {
            ((BoundingBox)boundingBox).union(token.getBoundingBox());
        }
        return boundingBox;
    }
}

