/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.text;

import java.util.Arrays;
import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;

public class TextStyle
implements Comparable<TextStyle> {
    private Double fontWeight;
    private Double fontSize;
    private double[] textColor;
    private Double italicAngle;
    private String fontName;
    private Double maxFontSize;

    public TextStyle(Double fontWeight, Double fontSize, double[] textColor, Double italicAngle, String fontName, Double maxFontSize) {
        this.fontWeight = fontWeight;
        this.fontSize = fontSize;
        this.textColor = textColor;
        this.italicAngle = italicAngle;
        this.fontName = fontName;
        this.maxFontSize = maxFontSize;
    }

    public Double getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(Double fontWeight) {
        this.fontWeight = fontWeight;
    }

    public Double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Double fontSize) {
        this.fontSize = fontSize;
    }

    public double[] getTextColor() {
        return this.textColor;
    }

    public void setTextColor(double[] textColor) {
        this.textColor = textColor;
    }

    public Double getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(Double italicAngle) {
        this.italicAngle = italicAngle;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public Double getMaxFontSize() {
        return this.maxFontSize;
    }

    public void setMaxFontSize(Double maxFontSize) {
        this.maxFontSize = maxFontSize;
    }

    public static boolean areSameTextStyles(TextStyle style1, TextStyle style2) {
        if (!Objects.equals(style1.fontWeight, style2.fontWeight)) {
            return false;
        }
        if (!Objects.equals(style1.fontName, style2.fontName)) {
            return false;
        }
        if (!Arrays.equals(style1.textColor, style2.textColor)) {
            return false;
        }
        if (!Objects.equals(style1.italicAngle, style2.italicAngle)) {
            return false;
        }
        if (!Objects.equals(style1.maxFontSize, style2.maxFontSize)) {
            return false;
        }
        return Objects.equals(style1.fontSize, style2.fontSize);
    }

    @Override
    public int compareTo(TextStyle textStyle) {
        if (!Objects.equals(this.maxFontSize, textStyle.maxFontSize)) {
            return textStyle.maxFontSize - this.maxFontSize > 0.0 ? 1 : -1;
        }
        if (!Objects.equals(this.fontWeight, textStyle.fontWeight)) {
            return textStyle.fontWeight - this.fontWeight > 0.0 ? 1 : -1;
        }
        return 0;
    }

    public static TextStyle getTextStyle(SemanticTextNode semanticTextNode) {
        return new TextStyle(semanticTextNode.getFontWeight(), semanticTextNode.getFontSize(), semanticTextNode.getTextColor(), semanticTextNode.getItalicAngle(), semanticTextNode.getFontName(), semanticTextNode.getMaxFontSize());
    }
}

