/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticAnnot;
import org.verapdf.wcag.algorithms.entities.SemanticCaption;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.SemanticHeading;
import org.verapdf.wcag.algorithms.entities.SemanticNumberHeading;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.WCAGConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.CaptionUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ErrorCodes;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.HeadingUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.WCAGProgressStatus;

public class HeadingCaptionConsumer
extends WCAGConsumer
implements Consumer<INode> {
    public static final double MERGE_PROBABILITY_THRESHOLD = 0.75;

    @Override
    public boolean run() {
        if (!StaticContainers.isHuman().booleanValue()) {
            return false;
        }
        if (!this.startStep()) {
            return true;
        }
        StaticContainers.getDocument().getTree().forEach(this);
        return false;
    }

    @Override
    public void accept(INode node) {
        if (node.getChildren().isEmpty()) {
            return;
        }
        boolean isLeafChild = node.getChildren().stream().allMatch(child -> child instanceof SemanticSpan || child instanceof SemanticFigure || child instanceof SemanticAnnot || child.getSemanticType() == null);
        if (isLeafChild) {
            return;
        }
        this.acceptChildrenSemanticHeading(node);
        this.acceptChildrenSemanticCaption(node);
    }

    private void acceptChildrenSemanticHeading(INode node) {
        List<Integer> indexes;
        INode child2;
        ArrayList<INode> children = new ArrayList<INode>(node.getChildren().size());
        ArrayList<SemanticTextNode> textChildren = new ArrayList<SemanticTextNode>(node.getChildren().size());
        for (INode child2 : node.getChildren()) {
            SemanticTextNode textNode;
            INode accumulatedChild;
            if (child2 == null || SemanticType.BLOCK_QUOTE == child2.getInitialSemanticType() || !((accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(child2)) instanceof SemanticTextNode) || (textNode = (SemanticTextNode)accumulatedChild).isSpaceNode() || textNode.isEmpty()) continue;
            children.add(child2);
            textChildren.add(textNode);
        }
        if (children.isEmpty()) {
            return;
        }
        boolean singleChild = false;
        if (children.size() == 1 && HeadingUtils.isInitialHeadingNode(child2 = (INode)children.get(0))) {
            INode nextNode = HeadingCaptionConsumer.getNextNonEmptyTextNode(child2);
            singleChild = true;
            if (nextNode != null) {
                children.add(nextNode);
                textChildren.add((SemanticTextNode)StaticContainers.getAccumulatedNodeMapper().get(nextNode));
            }
        }
        if ((indexes = HeadingCaptionConsumer.getIndexes(textChildren)).size() == 1) {
            return;
        }
        HeadingCaptionConsumer.acceptHeadings(children, textChildren, indexes, singleChild);
    }

    private static void acceptHeadings(List<INode> children, List<SemanticTextNode> textChildren, List<Integer> indexes, boolean singleChild) {
        for (int i = 0; i < indexes.size() - 1; ++i) {
            int index;
            if (indexes.get(i + 1) - indexes.get(i) > 3) continue;
            LinkedList<Double> probabilities = new LinkedList<Double>();
            boolean areHeadings = true;
            for (index = indexes.get(i).intValue(); index < indexes.get(i + 1); ++index) {
                double probability = NodeUtils.headingProbability(textChildren.get(index), i != 0 ? textChildren.get(indexes.get(i - 1)) : null, textChildren.get(indexes.get(i + 1)), children.get(index));
                if (probability < 0.75) {
                    areHeadings = false;
                    break;
                }
                probabilities.add(probability);
            }
            if (!areHeadings) continue;
            if (singleChild) {
                ErrorCodes.addErrorCodeWithArguments(children.get(0), 1300, new Object[0]);
            }
            for (index = indexes.get(i).intValue(); index < indexes.get(i + 1); ++index) {
                SemanticType type;
                SemanticHeading accumulatedHeadingChild;
                INode child = children.get(index);
                SemanticTextNode textChild = textChildren.get(index);
                if (child.getInitialSemanticType() == SemanticType.NUMBER_HEADING) {
                    accumulatedHeadingChild = new SemanticNumberHeading(textChild);
                    type = SemanticType.NUMBER_HEADING;
                } else {
                    accumulatedHeadingChild = new SemanticHeading(textChild);
                    type = SemanticType.HEADING;
                }
                textChildren.set(index, accumulatedHeadingChild);
                StaticContainers.getAccumulatedNodeMapper().updateNode(child, accumulatedHeadingChild, (Double)probabilities.get(index - indexes.get(i)) * child.getCorrectSemanticScore(), type);
            }
        }
    }

    private static INode getNextNonEmptyTextNode(INode node) {
        SemanticTextNode textNode;
        INode accumulatedChild;
        INode currentNode;
        for (currentNode = node.getNextNode(); currentNode != null && (!((accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(currentNode)) instanceof SemanticTextNode) || (textNode = (SemanticTextNode)accumulatedChild).isSpaceNode() || textNode.isEmpty()); currentNode = currentNode.getNextNode()) {
        }
        if (currentNode == null) {
            return null;
        }
        block1: while (!currentNode.getChildren().isEmpty()) {
            for (INode child : currentNode.getChildren()) {
                SemanticTextNode textNode2;
                INode accumulatedChild2 = StaticContainers.getAccumulatedNodeMapper().get(child);
                if (!(accumulatedChild2 instanceof SemanticTextNode) || (textNode2 = (SemanticTextNode)accumulatedChild2).isSpaceNode() || textNode2.isEmpty()) continue;
                if (child.getCorrectSemanticScore() > 0.75) {
                    return child;
                }
                currentNode = child;
                continue block1;
            }
        }
        return currentNode;
    }

    private static List<Integer> getIndexes(List<SemanticTextNode> textChildren) {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        indexes.add(0);
        for (int index = 1; index < textChildren.size(); ++index) {
            if (NodeUtils.hasSameStyle(textChildren.get(index - 1), textChildren.get(index), NodeUtils.HEADING_EPSILONS[0], NodeUtils.HEADING_EPSILONS[0])) continue;
            indexes.add(index);
        }
        return indexes;
    }

    private void acceptChildrenSemanticCaption(INode node) {
        INode imageNode = null;
        INode lastTextNode = null;
        for (INode child : node.getChildren()) {
            if (child == null) continue;
            INode accumulatedChild = StaticContainers.getAccumulatedNodeMapper().get(child);
            if (accumulatedChild instanceof SemanticTextNode) {
                SemanticTextNode textNode = (SemanticTextNode)accumulatedChild;
                if (textNode.isSpaceNode() || textNode.isEmpty()) continue;
                if (imageNode != null) {
                    this.acceptImageCaption(imageNode, lastTextNode, child);
                    imageNode = null;
                }
                lastTextNode = child;
                continue;
            }
            if (!(accumulatedChild instanceof SemanticFigure)) continue;
            if (imageNode != null) {
                this.acceptImageCaption(imageNode, lastTextNode, null);
                lastTextNode = null;
            }
            imageNode = child;
        }
        if (imageNode != null) {
            this.acceptImageCaption(imageNode, lastTextNode, null);
        }
    }

    private void acceptImageCaption(INode imageNode, INode previousNode, INode nextNode) {
        INode captionNode;
        double captionProbability;
        double nextCaptionProbability;
        SemanticFigure figure = (SemanticFigure)StaticContainers.getAccumulatedNodeMapper().get(imageNode);
        if (figure.getImages().isEmpty()) {
            return;
        }
        double previousCaptionProbability = CaptionUtils.imageCaptionProbability(previousNode, figure);
        if (previousCaptionProbability > (nextCaptionProbability = CaptionUtils.imageCaptionProbability(nextNode, figure))) {
            captionProbability = previousCaptionProbability;
            captionNode = previousNode;
        } else {
            captionProbability = nextCaptionProbability;
            captionNode = nextNode;
        }
        if (captionProbability >= 0.75) {
            StaticContainers.getAccumulatedNodeMapper().updateNode(captionNode, new SemanticCaption((SemanticTextNode)StaticContainers.getAccumulatedNodeMapper().get(captionNode)), captionProbability * captionNode.getCorrectSemanticScore(), SemanticType.CAPTION);
        }
    }

    @Override
    public WCAGProgressStatus getWCAGProgressStatus() {
        return WCAGProgressStatus.HEADING_AND_CAPTION_DETECTION;
    }
}

