/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ChunksMergeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.HeadingUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.ListLabelsDetectionAlgorithm;

public class CaptionUtils {
    private static final double FLOATING_POINT_OPERATIONS_EPS = 1.0E-7;
    private static final double[] DEFAULT_INTERVAL_BEFORE_IMAGE = new double[]{-0.2, 1.8};
    private static final double[] DEFAULT_INTERVAL_AFTER_IMAGE = new double[]{0.0, 1.8};
    private static final double[] DEFAULT_INTERVAL_BEFORE_LEFT_IMAGE_SIDE = new double[]{0.0, 1.8};
    private static final double[] DEFAULT_INTERVAL_AFTER_RIGHT_IMAGE_SIDE = new double[]{0.0, 1.8};
    private static final double IMAGE_INTERVAL_STANDARD = 1.0;
    private static final double IMAGE_INTERVAL_SIDE_STANDARD = 1.0;
    private static final double[] CAPTION_PROBABILITY_PARAMS = new double[]{1.0, 0.95, 0.9, 0.85, 0.2, 0.1, 0.03, 0.003};
    private static final double WITH_TOLERANCE_FACTOR = 0.33;
    private static final String CAPTION_REGEX = "^\\s*(\\S+)\\s*(\\d*)\\s*([.:]?)\\s*(\\S*)";
    private static final Pattern PATTERN = Pattern.compile("^\\s*(\\S+)\\s*(\\d*)\\s*([.:]?)\\s*(\\S*)");
    private static final Map<SemanticType, List<String>> OBJECT_NAMES = new HashMap<SemanticType, List<String>>();

    public static double imageCaptionProbability(INode node, SemanticFigure imageNode) {
        if (node == null) {
            return 0.0;
        }
        if (HeadingUtils.isDetectedHeadingNode(node) || StaticContainers.isDataLoader() && node.getSemanticType() == SemanticType.LIST) {
            return 0.0;
        }
        INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
        if (!(accumulatedNode instanceof SemanticTextNode)) {
            return 0.0;
        }
        SemanticTextNode textNode = (SemanticTextNode)accumulatedNode;
        double captionContentProbability = CaptionUtils.captionContentProbability(textNode, imageNode.getSemanticType());
        double linesNumberCaptionProbability = CaptionUtils.getLinesNumberCaptionProbability(textNode);
        double captionProbability = CaptionUtils.captionVerticalProbability(textNode, imageNode.getBoundingBox());
        captionProbability *= CaptionUtils.captionHorizontalProbability(textNode, imageNode.getBoundingBox());
        captionProbability *= linesNumberCaptionProbability;
        captionProbability += captionContentProbability;
        double sideCaptionProbability = 0.0;
        if (captionContentProbability > 1.0E-4) {
            sideCaptionProbability = CaptionUtils.sideCaptionHorizontalProbability(textNode, imageNode.getBoundingBox());
            sideCaptionProbability *= CaptionUtils.sideCaptionVerticalProbability(textNode, imageNode.getBoundingBox());
            sideCaptionProbability *= CaptionUtils.sideCaptionSpacingProbability(textNode, imageNode.getBoundingBox());
            sideCaptionProbability *= linesNumberCaptionProbability;
            sideCaptionProbability += captionContentProbability;
        }
        return Math.min(Math.max(captionProbability, sideCaptionProbability), 1.0);
    }

    public static double tableCaptionProbability(INode node, BoundingBox tableBoundingBox) {
        if (node == null) {
            return 0.0;
        }
        if (HeadingUtils.isDetectedHeadingNode(node) || node.getSemanticType() == SemanticType.LIST) {
            return 0.0;
        }
        INode accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
        if (accumulatedNode == null) {
            return 0.0;
        }
        if (!(accumulatedNode instanceof SemanticTextNode)) {
            return 0.0;
        }
        SemanticTextNode textNode = (SemanticTextNode)accumulatedNode;
        double captionProbability = CaptionUtils.captionVerticalProbability(textNode, tableBoundingBox);
        captionProbability *= CaptionUtils.captionHorizontalProbability(textNode, tableBoundingBox);
        captionProbability *= CaptionUtils.getLinesNumberCaptionProbability(textNode);
        return Math.min(captionProbability += CaptionUtils.captionContentProbability(textNode, SemanticType.TABLE), 1.0);
    }

    private static double getLinesNumberCaptionProbability(SemanticTextNode textNode) {
        return Math.max(0.0, 1.0 - (StaticContainers.isDataLoader() ? CAPTION_PROBABILITY_PARAMS[7] : CAPTION_PROBABILITY_PARAMS[6]) * (double)(textNode.getLinesNumber() - 1) * (double)(textNode.getLinesNumber() - 1));
    }

    public static boolean isContaining(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        double tol = 0.33 * textNode.getFontSize();
        return imageBoundingBox.getLeftX() + tol > textNode.getLeftX() && imageBoundingBox.getRightX() < textNode.getRightX() + tol;
    }

    private static boolean isContaining(BoundingBox imageBoundingBox, SemanticTextNode textNode) {
        double tol = 0.33 * textNode.getFontSize();
        return textNode.getLeftX() + tol > imageBoundingBox.getLeftX() && textNode.getRightX() < imageBoundingBox.getRightX() + tol;
    }

    public static boolean isContaining(TextLine firstLine, TextLine secondLine) {
        double tol = 0.33 * firstLine.getFontSize();
        return secondLine.getLeftX() + tol > firstLine.getLeftX() && secondLine.getRightX() < firstLine.getRightX() + tol;
    }

    private static boolean areStrongCenterOverlapping(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        double tol = 0.33 * textNode.getFontSize();
        double textCenter = textNode.getBoundingBox().getCenterX();
        double imageCenter = imageBoundingBox.getCenterX();
        if (textCenter + tol > imageBoundingBox.getRightX() || textCenter < imageBoundingBox.getLeftX() + tol) {
            return false;
        }
        return !(imageCenter + tol > textNode.getRightX()) && !(imageCenter < textNode.getLeftX() + tol);
    }

    private static boolean areCenterOverlapping(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        double tol = 0.33 * textNode.getFontSize();
        double textCenter = textNode.getBoundingBox().getCenterX();
        double imageCenter = imageBoundingBox.getCenterX();
        if (textCenter + tol < imageBoundingBox.getRightX() && textCenter > imageBoundingBox.getLeftX() + tol) {
            return true;
        }
        return imageCenter + tol < textNode.getRightX() && imageCenter > textNode.getLeftX() + tol;
    }

    public static boolean areOverlapping(TextLine textLine, BoundingBox boundingBox) {
        double tol = 0.33 * textLine.getFontSize();
        return textLine.getLeftX() + tol < boundingBox.getRightX() && boundingBox.getLeftX() + tol < textLine.getRightX();
    }

    private static boolean areOverlapping(SemanticTextNode textNode, SemanticFigure imageNode) {
        double tol = 0.33 * textNode.getFontSize();
        return textNode.getLeftX() + tol < imageNode.getRightX() && imageNode.getLeftX() + tol < textNode.getRightX();
    }

    private static double captionVerticalProbability(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        if (textNode.getLastPageNumber() == null || imageBoundingBox.getPageNumber() == null || textNode.getPageNumber() == null || imageBoundingBox.getLastPageNumber() == null) {
            return 0.0;
        }
        if (!textNode.getPageNumber().equals(textNode.getLastPageNumber()) || !textNode.getPageNumber().equals(imageBoundingBox.getPageNumber())) {
            return 0.0;
        }
        double firstBaseline = textNode.getFirstBaseline();
        double lastBaseline = textNode.getLastBaseline();
        if (lastBaseline > imageBoundingBox.getTopY() + 1.0E-7) {
            return ChunksMergeUtils.getUniformProbability(DEFAULT_INTERVAL_BEFORE_IMAGE, (textNode.getBottomY() - imageBoundingBox.getTopY()) / textNode.getFontSize(), 1.0);
        }
        if (firstBaseline < imageBoundingBox.getBottomY() - 1.0E-7) {
            return ChunksMergeUtils.getUniformProbability(DEFAULT_INTERVAL_AFTER_IMAGE, (imageBoundingBox.getBottomY() - textNode.getTopY()) / textNode.getFontSize(), 1.0);
        }
        return 0.0;
    }

    public static double captionContentProbability(SemanticTextNode textNode, SemanticType type) {
        if (!StaticContainers.isDataLoader()) {
            String value = textNode.getFirstLine().getValue().trim();
            if (value.startsWith(type.getValue())) {
                if (!(value = value.substring(type.getValue().length()).trim()).isEmpty() && ListLabelsDetectionAlgorithm.getRegexStartLength(value, "\\d+") > 0) {
                    return CAPTION_PROBABILITY_PARAMS[4];
                }
                return CAPTION_PROBABILITY_PARAMS[5];
            }
            return 0.0;
        }
        Matcher matcher = PATTERN.matcher(textNode.getFirstLine().getValue());
        if (!matcher.find()) {
            return 0.0;
        }
        List<String> objectNames = OBJECT_NAMES.get((Object)type);
        if (!objectNames.contains(matcher.group(1).toLowerCase())) {
            return 0.0;
        }
        double captionProbability = CAPTION_PROBABILITY_PARAMS[5];
        if (!matcher.group(2).isEmpty()) {
            captionProbability += CAPTION_PROBABILITY_PARAMS[5];
        }
        if (matcher.group(4).isEmpty() == matcher.group(3).isEmpty()) {
            captionProbability += CAPTION_PROBABILITY_PARAMS[5];
        }
        return captionProbability;
    }

    public static double captionHorizontalProbability(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        if (CaptionUtils.isContaining(imageBoundingBox, textNode) && CaptionUtils.areStrongCenterOverlapping(textNode, imageBoundingBox)) {
            return CAPTION_PROBABILITY_PARAMS[0];
        }
        if (CaptionUtils.isContaining(imageBoundingBox, textNode) && CaptionUtils.areCenterOverlapping(textNode, imageBoundingBox)) {
            return CAPTION_PROBABILITY_PARAMS[1];
        }
        if (CaptionUtils.isContaining(textNode, imageBoundingBox) && CaptionUtils.areStrongCenterOverlapping(textNode, imageBoundingBox)) {
            return CAPTION_PROBABILITY_PARAMS[2];
        }
        if (CaptionUtils.isContaining(textNode, imageBoundingBox) && CaptionUtils.areCenterOverlapping(textNode, imageBoundingBox)) {
            return CAPTION_PROBABILITY_PARAMS[3];
        }
        return 0.0;
    }

    private static double sideCaptionHorizontalProbability(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        if (textNode.getLeftX() > imageBoundingBox.getRightX() || textNode.getRightX() < imageBoundingBox.getLeftX()) {
            return 1.0;
        }
        return 0.0;
    }

    private static double sideCaptionVerticalProbability(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        if (textNode.getLastPageNumber() == null || imageBoundingBox.getPageNumber() == null || textNode.getPageNumber() == null || imageBoundingBox.getLastPageNumber() == null) {
            return 0.0;
        }
        if (!textNode.getPageNumber().equals(textNode.getLastPageNumber()) || !textNode.getPageNumber().equals(imageBoundingBox.getPageNumber())) {
            return 0.0;
        }
        if (textNode.getTopY() < imageBoundingBox.getTopY() - 1.0E-7 && textNode.getBottomY() > imageBoundingBox.getBottomY() + 1.0E-7) {
            return 1.0;
        }
        return 0.0;
    }

    private static double sideCaptionSpacingProbability(SemanticTextNode textNode, BoundingBox imageBoundingBox) {
        if (textNode.getLeftX() > imageBoundingBox.getRightX()) {
            return ChunksMergeUtils.getUniformProbability(DEFAULT_INTERVAL_AFTER_RIGHT_IMAGE_SIDE, (textNode.getLeftX() - imageBoundingBox.getRightX()) / textNode.getFontSize(), 1.0);
        }
        if (textNode.getRightX() < imageBoundingBox.getLeftX()) {
            return ChunksMergeUtils.getUniformProbability(DEFAULT_INTERVAL_BEFORE_LEFT_IMAGE_SIDE, (imageBoundingBox.getLeftX() - textNode.getRightX()) / textNode.getFontSize(), 1.0);
        }
        return 0.0;
    }

    static {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add("table");
        OBJECT_NAMES.put(SemanticType.TABLE, tableNames);
        ArrayList<String> figureNames = new ArrayList<String>();
        figureNames.add("figure");
        figureNames.add("image");
        OBJECT_NAMES.put(SemanticType.FIGURE, figureNames);
    }
}

