/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.cybozu;

import com.google.common.base.Optional;
import com.optimaize.langdetect.DetectedLanguage;
import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.LanguageDetectorBuilder;
import com.optimaize.langdetect.cybozu.GenProfile;
import com.optimaize.langdetect.cybozu.util.LangProfile;
import com.optimaize.langdetect.frma.LangProfileWriter;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractors;
import com.optimaize.langdetect.profiles.LanguageProfile;
import com.optimaize.langdetect.profiles.LanguageProfileReader;
import com.optimaize.langdetect.text.CommonTextObjectFactories;
import com.optimaize.langdetect.text.TextObject;
import com.optimaize.langdetect.text.TextObjectFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineInterface {
    private static final double DEFAULT_ALPHA = 0.5;
    private final Map<String, String> opt_with_value = new HashMap<String, String>();
    private final Map<String, String> values = new HashMap<String, String>();
    private final Set<String> opt_without_value = new HashSet<String>();
    private final List<String> arglist = new ArrayList<String>();

    public static void main(String[] args) throws IOException {
        CommandLineInterface cli = new CommandLineInterface();
        cli.addOpt("-d", "directory", "./");
        cli.addOpt("-a", "alpha", "0.5");
        cli.addOpt("-s", "seed", null);
        cli.parse(args);
        if (cli.hasParam("--genprofile")) {
            cli.generateProfile();
        } else if (cli.hasParam("--detectlang")) {
            cli.detectLang();
        } else if (cli.hasParam("--batchtest")) {
            cli.batchTest();
        }
    }

    private void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (this.opt_with_value.containsKey(args[i])) {
                String key = this.opt_with_value.get(args[i]);
                this.values.put(key, args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].startsWith("-")) {
                this.opt_without_value.add(args[i]);
                continue;
            }
            this.arglist.add(args[i]);
        }
    }

    private void addOpt(String opt, String key, String value) {
        this.opt_with_value.put(opt, key);
        this.values.put(key, value);
    }

    @NotNull
    private String requireParamString(@NotNull String key) {
        String s2 = this.values.get(key);
        if (s2 == null || s2.isEmpty()) {
            throw new RuntimeException("Missing command line param: " + key);
        }
        return s2;
    }

    private double getParamDouble(String key, double defaultValue) {
        String value = this.values.get(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid double value: >>>" + value + "<<<", e);
        }
    }

    @Nullable
    private Long getParamLongOrNull(String key) {
        String value = this.values.get(key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid long value: >>>" + value + "<<<", e);
        }
    }

    private boolean hasParam(String opt) {
        return this.opt_without_value.contains(opt);
    }

    private File searchFile(File directory, String pattern) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Not a directly: " + directory);
        }
        File[] files = directory.listFiles();
        assert (files != null);
        for (File file : files) {
            if (!file.getName().matches(pattern)) continue;
            return file;
        }
        return null;
    }

    public void generateProfile() {
        String lang;
        File directory = new File(this.arglist.get(0));
        File file = this.searchFile(directory, (lang = this.arglist.get(1)) + "wiki-.*-abstract\\.xml.*");
        if (file == null) {
            System.err.println("Not Found text file : lang = " + lang);
            return;
        }
        try (FileOutputStream outputStream = new FileOutputStream(new File(lang));){
            LangProfile profile = GenProfile.load(lang, file);
            profile.omitLessFreq();
            new LangProfileWriter().write(profile, outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void detectLang() throws IOException {
        LanguageDetector languageDetector = this.makeDetector();
        TextObjectFactory textObjectFactory = CommonTextObjectFactories.forDetectingOnLargeText();
        for (String filename : this.arglist) {
            BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));
            Throwable throwable = null;
            try {
                TextObject textObject = textObjectFactory.create().append(is);
                List<DetectedLanguage> probabilities = languageDetector.getProbabilities(textObject);
                System.out.println(filename + ":" + probabilities);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    public void batchTest() throws IOException {
        LanguageDetector languageDetector = this.makeDetector();
        TextObjectFactory textObjectFactory = CommonTextObjectFactories.forDetectingOnLargeText();
        HashMap result = new HashMap();
        for (String filename : this.arglist) {
            try (BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));){
                while (is.ready()) {
                    String line = is.readLine();
                    int idx = line.indexOf(9);
                    if (idx <= 0) continue;
                    String correctLang = line.substring(0, idx);
                    String text = line.substring(idx + 1);
                    TextObject textObject = textObjectFactory.forText(text);
                    Optional<LdLocale> lang = languageDetector.detect(textObject);
                    if (!result.containsKey(correctLang)) {
                        result.put(correctLang, new ArrayList());
                    }
                    if (lang.isPresent()) {
                        ((List)result.get(correctLang)).add(lang.toString());
                    } else {
                        ((List)result.get(correctLang)).add("unknown");
                    }
                    if (!this.hasParam("--debug")) continue;
                    System.out.println(correctLang + "," + lang + "," + (text.length() > 100 ? text.substring(0, 100) : text));
                }
            }
            ArrayList langList = new ArrayList(result.keySet());
            Collections.sort(langList);
            int totalCount = 0;
            int totalCorrect = 0;
            for (String lang : langList) {
                HashMap<String, Integer> resultCount = new HashMap<String, Integer>();
                int count = 0;
                List list = (List)result.get(lang);
                for (String detectedLang : list) {
                    ++count;
                    if (resultCount.containsKey(detectedLang)) {
                        resultCount.put(detectedLang, (Integer)resultCount.get(detectedLang) + 1);
                        continue;
                    }
                    resultCount.put(detectedLang, 1);
                }
                int correct = resultCount.containsKey(lang) ? (Integer)resultCount.get(lang) : 0;
                double rate = (double)correct / (double)count;
                System.out.println(String.format("%s (%d/%d=%.2f): %s", lang, correct, count, rate, resultCount));
                totalCorrect += correct;
                totalCount += count;
            }
            System.out.println(String.format("total: %d/%d = %.3f", totalCorrect, totalCount, (double)totalCorrect / (double)totalCount));
        }
    }

    private LanguageDetector makeDetector() throws IOException {
        double alpha = this.getParamDouble("alpha", 0.5);
        String profileDirectory = this.requireParamString("directory") + "/";
        Optional<Long> seed = Optional.fromNullable(this.getParamLongOrNull("seed"));
        List<LanguageProfile> languageProfiles = new LanguageProfileReader().readAll(new File(profileDirectory));
        return LanguageDetectorBuilder.create(NgramExtractors.standard()).alpha(alpha).seed(seed).shortTextAlgorithm(50).withProfiles(languageProfiles).build();
    }
}

