/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker;

import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.core.predicate.PredicateCreator;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;

public class CircuitBreakerConfig
implements Serializable {
    private static final long serialVersionUID = -5429814941777001669L;
    public static final int DEFAULT_FAILURE_RATE_THRESHOLD = 50;
    public static final int DEFAULT_SLOW_CALL_RATE_THRESHOLD = 100;
    public static final int DEFAULT_WAIT_DURATION_IN_OPEN_STATE = 60;
    public static final int DEFAULT_PERMITTED_CALLS_IN_HALF_OPEN_STATE = 10;
    public static final int DEFAULT_MINIMUM_NUMBER_OF_CALLS = 100;
    public static final int DEFAULT_SLIDING_WINDOW_SIZE = 100;
    public static final int DEFAULT_SLOW_CALL_DURATION_THRESHOLD = 60;
    public static final int DEFAULT_WAIT_DURATION_IN_HALF_OPEN_STATE = 0;
    public static final SlidingWindowType DEFAULT_SLIDING_WINDOW_TYPE = SlidingWindowType.COUNT_BASED;
    public static final boolean DEFAULT_WRITABLE_STACK_TRACE_ENABLED = true;
    private static final Predicate<Throwable> DEFAULT_RECORD_EXCEPTION_PREDICATE = throwable -> true;
    private static final Predicate<Throwable> DEFAULT_IGNORE_EXCEPTION_PREDICATE = throwable -> false;
    private static final Function<Clock, Long> DEFAULT_TIMESTAMP_FUNCTION = clock -> System.nanoTime();
    private static final TimeUnit DEFAULT_TIMESTAMP_UNIT = TimeUnit.NANOSECONDS;
    private static final Predicate<Object> DEFAULT_RECORD_RESULT_PREDICATE = object -> false;
    private Predicate<Throwable> recordExceptionPredicate = DEFAULT_RECORD_EXCEPTION_PREDICATE;
    private Predicate<Throwable> ignoreExceptionPredicate = DEFAULT_IGNORE_EXCEPTION_PREDICATE;
    private Function<Clock, Long> currentTimestampFunction = DEFAULT_TIMESTAMP_FUNCTION;
    private TimeUnit timestampUnit = DEFAULT_TIMESTAMP_UNIT;
    private transient Predicate<Object> recordResultPredicate = DEFAULT_RECORD_RESULT_PREDICATE;
    private Class<? extends Throwable>[] recordExceptions = new Class[0];
    private Class<? extends Throwable>[] ignoreExceptions = new Class[0];
    private float failureRateThreshold = 50.0f;
    private int permittedNumberOfCallsInHalfOpenState = 10;
    private int slidingWindowSize = 100;
    private SlidingWindowType slidingWindowType = DEFAULT_SLIDING_WINDOW_TYPE;
    private int minimumNumberOfCalls = 100;
    private boolean writableStackTraceEnabled = true;
    private boolean automaticTransitionFromOpenToHalfOpenEnabled = false;
    private IntervalFunction waitIntervalFunctionInOpenState = IntervalFunction.of(Duration.ofSeconds(60L));
    private float slowCallRateThreshold = 100.0f;
    private Duration slowCallDurationThreshold = Duration.ofSeconds(60L);
    private Duration maxWaitDurationInHalfOpenState = Duration.ofSeconds(0L);

    private CircuitBreakerConfig() {
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(CircuitBreakerConfig baseConfig) {
        return new Builder(baseConfig);
    }

    public static CircuitBreakerConfig ofDefaults() {
        return new Builder().build();
    }

    public float getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    @Deprecated
    public Duration getWaitDurationInOpenState() {
        return Duration.ofMillis((Long)this.waitIntervalFunctionInOpenState.apply(1));
    }

    public IntervalFunction getWaitIntervalFunctionInOpenState() {
        return this.waitIntervalFunctionInOpenState;
    }

    public int getSlidingWindowSize() {
        return this.slidingWindowSize;
    }

    public Predicate<Throwable> getRecordExceptionPredicate() {
        return this.recordExceptionPredicate;
    }

    public Predicate<Object> getRecordResultPredicate() {
        return this.recordResultPredicate;
    }

    public Predicate<Throwable> getIgnoreExceptionPredicate() {
        return this.ignoreExceptionPredicate;
    }

    public Function<Clock, Long> getCurrentTimestampFunction() {
        return this.currentTimestampFunction;
    }

    public TimeUnit getTimestampUnit() {
        return this.timestampUnit;
    }

    public boolean isAutomaticTransitionFromOpenToHalfOpenEnabled() {
        return this.automaticTransitionFromOpenToHalfOpenEnabled;
    }

    public int getMinimumNumberOfCalls() {
        return this.minimumNumberOfCalls;
    }

    public boolean isWritableStackTraceEnabled() {
        return this.writableStackTraceEnabled;
    }

    public int getPermittedNumberOfCallsInHalfOpenState() {
        return this.permittedNumberOfCallsInHalfOpenState;
    }

    public SlidingWindowType getSlidingWindowType() {
        return this.slidingWindowType;
    }

    public float getSlowCallRateThreshold() {
        return this.slowCallRateThreshold;
    }

    public Duration getSlowCallDurationThreshold() {
        return this.slowCallDurationThreshold;
    }

    public Duration getMaxWaitDurationInHalfOpenState() {
        return this.maxWaitDurationInHalfOpenState;
    }

    public String toString() {
        StringBuilder circuitBreakerConfig = new StringBuilder("CircuitBreakerConfig {");
        circuitBreakerConfig.append("recordExceptionPredicate=");
        circuitBreakerConfig.append(this.recordExceptionPredicate);
        circuitBreakerConfig.append(", ignoreExceptionPredicate=");
        circuitBreakerConfig.append(this.ignoreExceptionPredicate);
        circuitBreakerConfig.append(", recordExceptions=");
        circuitBreakerConfig.append(Arrays.toString(this.recordExceptions));
        circuitBreakerConfig.append(", ignoreExceptions=");
        circuitBreakerConfig.append(Arrays.toString(this.ignoreExceptions));
        circuitBreakerConfig.append(", failureRateThreshold=");
        circuitBreakerConfig.append(this.failureRateThreshold);
        circuitBreakerConfig.append(", permittedNumberOfCallsInHalfOpenState=");
        circuitBreakerConfig.append(this.permittedNumberOfCallsInHalfOpenState);
        circuitBreakerConfig.append(", slidingWindowSize=");
        circuitBreakerConfig.append(this.slidingWindowSize);
        circuitBreakerConfig.append(", slidingWindowType=");
        circuitBreakerConfig.append((Object)this.slidingWindowType);
        circuitBreakerConfig.append(", minimumNumberOfCalls=");
        circuitBreakerConfig.append(this.minimumNumberOfCalls);
        circuitBreakerConfig.append(", writableStackTraceEnabled=");
        circuitBreakerConfig.append(this.writableStackTraceEnabled);
        circuitBreakerConfig.append(", automaticTransitionFromOpenToHalfOpenEnabled=");
        circuitBreakerConfig.append(this.automaticTransitionFromOpenToHalfOpenEnabled);
        circuitBreakerConfig.append(", waitIntervalFunctionInOpenState=");
        circuitBreakerConfig.append(this.waitIntervalFunctionInOpenState);
        circuitBreakerConfig.append(", slowCallRateThreshold=");
        circuitBreakerConfig.append(this.slowCallRateThreshold);
        circuitBreakerConfig.append(", slowCallDurationThreshold=");
        circuitBreakerConfig.append(this.slowCallDurationThreshold);
        circuitBreakerConfig.append("}");
        return circuitBreakerConfig.toString();
    }

    static /* synthetic */ Function access$000() {
        return DEFAULT_TIMESTAMP_FUNCTION;
    }

    static /* synthetic */ TimeUnit access$100() {
        return DEFAULT_TIMESTAMP_UNIT;
    }

    static /* synthetic */ Predicate access$200() {
        return DEFAULT_RECORD_RESULT_PREDICATE;
    }

    static /* synthetic */ Class[] access$1002(CircuitBreakerConfig x0, Class[] x1) {
        x0.recordExceptions = x1;
        return x1;
    }

    static /* synthetic */ Class[] access$902(CircuitBreakerConfig x0, Class[] x1) {
        x0.ignoreExceptions = x1;
        return x1;
    }

    public static enum SlidingWindowType {
        TIME_BASED,
        COUNT_BASED;

    }

    public static class Builder {
        @Nullable
        private Predicate<Throwable> recordExceptionPredicate;
        @Nullable
        private Predicate<Throwable> ignoreExceptionPredicate;
        private Function<Clock, Long> currentTimestampFunction = CircuitBreakerConfig.access$000();
        private TimeUnit timestampUnit = CircuitBreakerConfig.access$100();
        private Class<? extends Throwable>[] recordExceptions = new Class[0];
        private Class<? extends Throwable>[] ignoreExceptions = new Class[0];
        private float failureRateThreshold = 50.0f;
        private int minimumNumberOfCalls = 100;
        private boolean writableStackTraceEnabled = true;
        private int permittedNumberOfCallsInHalfOpenState = 10;
        private int slidingWindowSize = 100;
        private Predicate<Object> recordResultPredicate = CircuitBreakerConfig.access$200();
        private IntervalFunction waitIntervalFunctionInOpenState = IntervalFunction.of(Duration.ofSeconds(60L));
        private boolean automaticTransitionFromOpenToHalfOpenEnabled = false;
        private SlidingWindowType slidingWindowType = DEFAULT_SLIDING_WINDOW_TYPE;
        private float slowCallRateThreshold = 100.0f;
        private Duration slowCallDurationThreshold = Duration.ofSeconds(60L);
        private Duration maxWaitDurationInHalfOpenState = Duration.ofSeconds(0L);
        private byte createWaitIntervalFunctionCounter = 0;

        public Builder(CircuitBreakerConfig baseConfig) {
            this.waitIntervalFunctionInOpenState = baseConfig.waitIntervalFunctionInOpenState;
            this.permittedNumberOfCallsInHalfOpenState = baseConfig.permittedNumberOfCallsInHalfOpenState;
            this.slidingWindowSize = baseConfig.slidingWindowSize;
            this.slidingWindowType = baseConfig.slidingWindowType;
            this.minimumNumberOfCalls = baseConfig.minimumNumberOfCalls;
            this.failureRateThreshold = baseConfig.failureRateThreshold;
            this.ignoreExceptions = baseConfig.ignoreExceptions;
            this.recordExceptions = baseConfig.recordExceptions;
            this.recordExceptionPredicate = baseConfig.recordExceptionPredicate;
            this.ignoreExceptionPredicate = baseConfig.ignoreExceptionPredicate;
            this.currentTimestampFunction = baseConfig.currentTimestampFunction;
            this.timestampUnit = baseConfig.timestampUnit;
            this.automaticTransitionFromOpenToHalfOpenEnabled = baseConfig.automaticTransitionFromOpenToHalfOpenEnabled;
            this.slowCallRateThreshold = baseConfig.slowCallRateThreshold;
            this.slowCallDurationThreshold = baseConfig.slowCallDurationThreshold;
            this.maxWaitDurationInHalfOpenState = baseConfig.maxWaitDurationInHalfOpenState;
            this.writableStackTraceEnabled = baseConfig.writableStackTraceEnabled;
            this.recordResultPredicate = baseConfig.recordResultPredicate;
        }

        public Builder() {
        }

        public Builder failureRateThreshold(float failureRateThreshold) {
            if (failureRateThreshold <= 0.0f || failureRateThreshold > 100.0f) {
                throw new IllegalArgumentException("failureRateThreshold must be between 1 and 100");
            }
            this.failureRateThreshold = failureRateThreshold;
            return this;
        }

        public Builder slowCallRateThreshold(float slowCallRateThreshold) {
            if (slowCallRateThreshold <= 0.0f || slowCallRateThreshold > 100.0f) {
                throw new IllegalArgumentException("slowCallRateThreshold must be between 1 and 100");
            }
            this.slowCallRateThreshold = slowCallRateThreshold;
            return this;
        }

        public Builder writableStackTraceEnabled(boolean writableStackTraceEnabled) {
            this.writableStackTraceEnabled = writableStackTraceEnabled;
            return this;
        }

        public Builder waitDurationInOpenState(Duration waitDurationInOpenState) {
            long waitDurationInMillis = waitDurationInOpenState.toMillis();
            if (waitDurationInMillis < 1L) {
                throw new IllegalArgumentException("waitDurationInOpenState must be at least 1[ms]");
            }
            this.waitIntervalFunctionInOpenState = IntervalFunction.of(waitDurationInMillis);
            this.createWaitIntervalFunctionCounter = (byte)(this.createWaitIntervalFunctionCounter + 1);
            return this;
        }

        public Builder waitIntervalFunctionInOpenState(IntervalFunction waitIntervalFunctionInOpenState) {
            this.waitIntervalFunctionInOpenState = waitIntervalFunctionInOpenState;
            this.createWaitIntervalFunctionCounter = (byte)(this.createWaitIntervalFunctionCounter + 1);
            return this;
        }

        public Builder slowCallDurationThreshold(Duration slowCallDurationThreshold) {
            if (slowCallDurationThreshold.toNanos() < 1L) {
                throw new IllegalArgumentException("slowCallDurationThreshold must be at least 1[ns]");
            }
            this.slowCallDurationThreshold = slowCallDurationThreshold;
            return this;
        }

        public Builder maxWaitDurationInHalfOpenState(Duration maxWaitDurationInHalfOpenState) {
            if (maxWaitDurationInHalfOpenState.toMillis() < 1L) {
                throw new IllegalArgumentException("maxWaitDurationInHalfOpenState must be at least 1[ms]");
            }
            this.maxWaitDurationInHalfOpenState = maxWaitDurationInHalfOpenState;
            return this;
        }

        public Builder permittedNumberOfCallsInHalfOpenState(int permittedNumberOfCallsInHalfOpenState) {
            if (permittedNumberOfCallsInHalfOpenState < 1) {
                throw new IllegalArgumentException("permittedNumberOfCallsInHalfOpenState must be greater than 0");
            }
            this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
            return this;
        }

        @Deprecated
        public Builder ringBufferSizeInHalfOpenState(int ringBufferSizeInHalfOpenState) {
            if (ringBufferSizeInHalfOpenState < 1) {
                throw new IllegalArgumentException("ringBufferSizeInHalfOpenState must be greater than 0");
            }
            this.permittedNumberOfCallsInHalfOpenState = ringBufferSizeInHalfOpenState;
            return this;
        }

        @Deprecated
        public Builder ringBufferSizeInClosedState(int ringBufferSizeInClosedState) {
            if (ringBufferSizeInClosedState < 1) {
                throw new IllegalArgumentException("ringBufferSizeInClosedState must be greater than 0");
            }
            return this.slidingWindow(ringBufferSizeInClosedState, ringBufferSizeInClosedState, SlidingWindowType.COUNT_BASED);
        }

        public Builder slidingWindow(int slidingWindowSize, int minimumNumberOfCalls, SlidingWindowType slidingWindowType) {
            if (slidingWindowSize < 1) {
                throw new IllegalArgumentException("slidingWindowSize must be greater than 0");
            }
            if (minimumNumberOfCalls < 1) {
                throw new IllegalArgumentException("minimumNumberOfCalls must be greater than 0");
            }
            this.minimumNumberOfCalls = slidingWindowType == SlidingWindowType.COUNT_BASED ? Math.min(minimumNumberOfCalls, slidingWindowSize) : minimumNumberOfCalls;
            this.slidingWindowSize = slidingWindowSize;
            this.slidingWindowType = slidingWindowType;
            return this;
        }

        public Builder slidingWindowSize(int slidingWindowSize) {
            if (slidingWindowSize < 1) {
                throw new IllegalArgumentException("slidingWindowSize must be greater than 0");
            }
            this.slidingWindowSize = slidingWindowSize;
            return this;
        }

        public Builder minimumNumberOfCalls(int minimumNumberOfCalls) {
            if (minimumNumberOfCalls < 1) {
                throw new IllegalArgumentException("minimumNumberOfCalls must be greater than 0");
            }
            this.minimumNumberOfCalls = minimumNumberOfCalls;
            return this;
        }

        public Builder slidingWindowType(SlidingWindowType slidingWindowType) {
            this.slidingWindowType = slidingWindowType;
            return this;
        }

        @Deprecated
        public Builder recordFailure(Predicate<Throwable> predicate) {
            this.recordExceptionPredicate = predicate;
            return this;
        }

        public Builder recordException(Predicate<Throwable> predicate) {
            this.recordExceptionPredicate = predicate;
            return this;
        }

        public Builder currentTimestampFunction(Function<Clock, Long> currentTimestampFunction, TimeUnit timeUnit) {
            this.timestampUnit = timeUnit;
            this.currentTimestampFunction = currentTimestampFunction;
            return this;
        }

        public Builder recordResult(Predicate<Object> predicate) {
            this.recordResultPredicate = predicate;
            return this;
        }

        public Builder ignoreException(Predicate<Throwable> predicate) {
            this.ignoreExceptionPredicate = predicate;
            return this;
        }

        @SafeVarargs
        public final Builder recordExceptions(Class<? extends Throwable> ... errorClasses) {
            this.recordExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        @SafeVarargs
        public final Builder ignoreExceptions(Class<? extends Throwable> ... errorClasses) {
            this.ignoreExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        public Builder enableAutomaticTransitionFromOpenToHalfOpen() {
            this.automaticTransitionFromOpenToHalfOpenEnabled = true;
            return this;
        }

        public Builder automaticTransitionFromOpenToHalfOpenEnabled(boolean enableAutomaticTransitionFromOpenToHalfOpen) {
            this.automaticTransitionFromOpenToHalfOpenEnabled = enableAutomaticTransitionFromOpenToHalfOpen;
            return this;
        }

        public CircuitBreakerConfig build() {
            CircuitBreakerConfig config = new CircuitBreakerConfig();
            config.waitIntervalFunctionInOpenState = this.validateWaitIntervalFunctionInOpenState();
            config.slidingWindowType = this.slidingWindowType;
            config.slowCallDurationThreshold = this.slowCallDurationThreshold;
            config.maxWaitDurationInHalfOpenState = this.maxWaitDurationInHalfOpenState;
            config.slowCallRateThreshold = this.slowCallRateThreshold;
            config.failureRateThreshold = this.failureRateThreshold;
            config.slidingWindowSize = this.slidingWindowSize;
            config.minimumNumberOfCalls = this.minimumNumberOfCalls;
            config.permittedNumberOfCallsInHalfOpenState = this.permittedNumberOfCallsInHalfOpenState;
            CircuitBreakerConfig.access$1002(config, this.recordExceptions);
            CircuitBreakerConfig.access$902(config, this.ignoreExceptions);
            config.automaticTransitionFromOpenToHalfOpenEnabled = this.automaticTransitionFromOpenToHalfOpenEnabled;
            config.writableStackTraceEnabled = this.writableStackTraceEnabled;
            config.recordExceptionPredicate = this.createRecordExceptionPredicate();
            config.ignoreExceptionPredicate = this.createIgnoreFailurePredicate();
            config.currentTimestampFunction = this.currentTimestampFunction;
            config.timestampUnit = this.timestampUnit;
            config.recordResultPredicate = this.recordResultPredicate;
            return config;
        }

        private Predicate<Throwable> createIgnoreFailurePredicate() {
            return PredicateCreator.createExceptionsPredicate(this.ignoreExceptions).map(predicate -> this.ignoreExceptionPredicate != null ? predicate.or(this.ignoreExceptionPredicate) : predicate).orElseGet(() -> this.ignoreExceptionPredicate != null ? this.ignoreExceptionPredicate : DEFAULT_IGNORE_EXCEPTION_PREDICATE);
        }

        private Predicate<Throwable> createRecordExceptionPredicate() {
            return PredicateCreator.createExceptionsPredicate(this.recordExceptions).map(predicate -> this.recordExceptionPredicate != null ? predicate.or(this.recordExceptionPredicate) : predicate).orElseGet(() -> this.recordExceptionPredicate != null ? this.recordExceptionPredicate : DEFAULT_RECORD_EXCEPTION_PREDICATE);
        }

        private IntervalFunction validateWaitIntervalFunctionInOpenState() {
            if (this.createWaitIntervalFunctionCounter > 1) {
                throw new IllegalStateException("The waitIntervalFunction was configured multiple times which could result in an undesired state. Please verify that waitIntervalFunctionInOpenState and waitDurationInOpenState are not used together.");
            }
            return this.waitIntervalFunctionInOpenState;
        }
    }
}

