/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.github.resilience4j.micrometer.tagged.BulkheadMetricNames;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

abstract class AbstractBulkheadMetrics
extends AbstractMetrics {
    protected final BulkheadMetricNames names;

    protected AbstractBulkheadMetrics(BulkheadMetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    @Deprecated
    protected AbstractBulkheadMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, Bulkhead bulkhead) {
        List<Tag> customTags = this.mapToTagsList(bulkhead.getTags().toJavaMap());
        this.registerMetrics(meterRegistry, bulkhead, customTags);
    }

    private void registerMetrics(MeterRegistry meterRegistry, Bulkhead bulkhead, List<Tag> customTags) {
        this.removeMetrics(meterRegistry, bulkhead.getName());
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        idSet.add(Gauge.builder(this.names.getAvailableConcurrentCallsMetricName(), bulkhead, bh -> bh.getMetrics().getAvailableConcurrentCalls()).description("The number of available permissions").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder(this.names.getMaxAllowedConcurrentCallsMetricName(), bulkhead, bh -> bh.getMetrics().getMaxAllowedConcurrentCalls()).description("The maximum number of available permissions").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        this.meterIdMap.put(bulkhead.getName(), idSet);
    }

    @Deprecated
    public static class MetricNames
    extends BulkheadMetricNames {
    }
}

