/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.github.resilience4j.micrometer.tagged.RateLimiterMetricNames;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

abstract class AbstractRateLimiterMetrics
extends AbstractMetrics {
    protected final RateLimiterMetricNames names;

    protected AbstractRateLimiterMetrics(RateLimiterMetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    @Deprecated
    protected AbstractRateLimiterMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, RateLimiter rateLimiter) {
        List<Tag> customTags = this.mapToTagsList(rateLimiter.getTags().toJavaMap());
        this.registerMetrics(meterRegistry, rateLimiter, customTags);
    }

    private void registerMetrics(MeterRegistry meterRegistry, RateLimiter rateLimiter, List<Tag> customTags) {
        this.removeMetrics(meterRegistry, rateLimiter.getName());
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        idSet.add(Gauge.builder(this.names.getAvailablePermissionsMetricName(), rateLimiter, rl -> rl.getMetrics().getAvailablePermissions()).description("The number of available permissions").tag("name", rateLimiter.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder(this.names.getWaitingThreadsMetricName(), rateLimiter, rl -> rl.getMetrics().getNumberOfWaitingThreads()).description("The number of waiting threads").tag("name", rateLimiter.getName()).tags(customTags).register(meterRegistry).getId());
        this.meterIdMap.put(rateLimiter.getName(), idSet);
    }

    @Deprecated
    public static class MetricNames
    extends RateLimiterMetricNames {
    }
}

