/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.github.resilience4j.micrometer.tagged.TimeLimiterMetricNames;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

abstract class AbstractTimeLimiterMetrics
extends AbstractMetrics {
    private static final String KIND_FAILED = "failed";
    private static final String KIND_SUCCESSFUL = "successful";
    private static final String KIND_TIMEOUT = "timeout";
    protected final TimeLimiterMetricNames names;

    protected AbstractTimeLimiterMetrics(TimeLimiterMetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    @Deprecated
    protected AbstractTimeLimiterMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, TimeLimiter timeLimiter) {
        List<Tag> customTags = this.mapToTagsList(timeLimiter.getTags().toJavaMap());
        this.registerMetrics(meterRegistry, timeLimiter, customTags);
    }

    protected void registerMetrics(MeterRegistry meterRegistry, TimeLimiter timeLimiter, List<Tag> customTags) {
        this.removeMetrics(meterRegistry, timeLimiter.getName());
        Counter successes = Counter.builder(this.names.getCallsMetricName()).description("The number of successful calls").tag("name", timeLimiter.getName()).tag("kind", KIND_SUCCESSFUL).tags(customTags).register(meterRegistry);
        Counter failures = Counter.builder(this.names.getCallsMetricName()).description("The number of failed calls").tag("name", timeLimiter.getName()).tag("kind", KIND_FAILED).tags(customTags).register(meterRegistry);
        Counter timeouts = Counter.builder(this.names.getCallsMetricName()).description("The number of timed out calls").tag("name", timeLimiter.getName()).tag("kind", KIND_TIMEOUT).tags(customTags).register(meterRegistry);
        timeLimiter.getEventPublisher().onSuccess(event -> successes.increment()).onError(event -> failures.increment()).onTimeout(event -> timeouts.increment());
        List<Meter.Id> ids = Arrays.asList(successes.getId(), failures.getId(), timeouts.getId());
        this.meterIdMap.put(timeLimiter.getName(), new HashSet<Meter.Id>(ids));
    }

    @Deprecated
    public static class MetricNames
    extends TimeLimiterMetricNames {
    }
}

