/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.guava.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import io.prometheus.client.SummaryMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CacheMetricsCollector
extends Collector {
    protected final ConcurrentMap<String, Cache> children = new ConcurrentHashMap<String, Cache>();

    public void addCache(String cacheName, Cache cache) {
        this.children.put(cacheName, cache);
    }

    public Cache removeCache(String cacheName) {
        return (Cache)this.children.remove(cacheName);
    }

    public void clear() {
        this.children.clear();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        List<String> labelNames = Arrays.asList("cache");
        CounterMetricFamily cacheHitTotal = new CounterMetricFamily("guava_cache_hit_total", "Cache hit totals", labelNames);
        mfs.add(cacheHitTotal);
        CounterMetricFamily cacheMissTotal = new CounterMetricFamily("guava_cache_miss_total", "Cache miss totals", labelNames);
        mfs.add(cacheMissTotal);
        CounterMetricFamily cacheRequestsTotal = new CounterMetricFamily("guava_cache_requests_total", "Cache request totals, hits + misses", labelNames);
        mfs.add(cacheRequestsTotal);
        CounterMetricFamily cacheEvictionTotal = new CounterMetricFamily("guava_cache_eviction_total", "Cache eviction totals, doesn't include manually removed entries", labelNames);
        mfs.add(cacheEvictionTotal);
        CounterMetricFamily cacheLoadFailure = new CounterMetricFamily("guava_cache_load_failure_total", "Cache load failures", labelNames);
        mfs.add(cacheLoadFailure);
        CounterMetricFamily cacheLoadTotal = new CounterMetricFamily("guava_cache_loads_total", "Cache loads: both success and failures", labelNames);
        mfs.add(cacheLoadTotal);
        GaugeMetricFamily cacheSize = new GaugeMetricFamily("guava_cache_size", "Cache size", labelNames);
        mfs.add(cacheSize);
        SummaryMetricFamily cacheLoadSummary = new SummaryMetricFamily("guava_cache_load_duration_seconds", "Cache load duration: both success and failures", labelNames);
        mfs.add(cacheLoadSummary);
        for (Map.Entry c : this.children.entrySet()) {
            List<String> cacheName = Arrays.asList((String)c.getKey());
            CacheStats stats = ((Cache)c.getValue()).stats();
            cacheHitTotal.addMetric(cacheName, stats.hitCount());
            cacheMissTotal.addMetric(cacheName, stats.missCount());
            cacheRequestsTotal.addMetric(cacheName, stats.requestCount());
            cacheEvictionTotal.addMetric(cacheName, stats.evictionCount());
            cacheSize.addMetric(cacheName, ((Cache)c.getValue()).size());
            if (!(c.getValue() instanceof LoadingCache)) continue;
            cacheLoadFailure.addMetric(cacheName, stats.loadExceptionCount());
            cacheLoadTotal.addMetric(cacheName, stats.loadCount());
            cacheLoadSummary.addMetric(cacheName, stats.loadCount(), (double)stats.totalLoadTime() / 1.0E9);
        }
        return mfs;
    }
}

