/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.util;

import java.util.jar.Manifest;
import net.loomchild.segment.util.ResourceNotFoundException;
import net.loomchild.segment.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Version {
    private static final Log log = LogFactory.getLog(Version.class);
    public static final String VERSION_ATTRIBUTE = "Implementation-Version";
    public static final String DATE_ATTRIBUTE = "Build-Date";
    private static Version instance = new Version();
    private String version;
    private String date;

    public static Version getInstance() {
        return instance;
    }

    private Version() {
        try {
            Manifest manifest = Util.getJarManifest(Version.class);
            this.version = manifest.getMainAttributes().getValue(VERSION_ATTRIBUTE);
            this.date = manifest.getMainAttributes().getValue(DATE_ATTRIBUTE);
        }
        catch (ResourceNotFoundException e) {
            log.debug("Version number cannot be retrieved.");
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getDate() {
        return this.date;
    }
}

