/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene46;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Version;

@Deprecated
public class Lucene46SegmentInfoFormat
extends SegmentInfoFormat {
    static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene46SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_CHECKSUM = 1;
    static final int VERSION_CURRENT = 1;

    @Override
    public SegmentInfo read(Directory dir, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segment, "", SI_EXTENSION);
        try (ChecksumIndexInput input = dir.openChecksumInput(fileName, context);){
            Version version;
            int codecVersion = CodecUtil.checkHeader(input, CODEC_NAME, 0, 1);
            try {
                version = Version.parse(input.readString());
            }
            catch (ParseException pe) {
                throw new CorruptIndexException("unable to parse version string: " + pe.getMessage(), input, (Throwable)pe);
            }
            int docCount = input.readInt();
            if (docCount < 0) {
                throw new CorruptIndexException("invalid docCount: " + docCount, input);
            }
            boolean isCompoundFile = input.readByte() == 1;
            Map<String, String> diagnostics = Collections.unmodifiableMap(input.readStringStringMap());
            Set<String> files = Collections.unmodifiableSet(input.readStringSet());
            if (codecVersion >= 1) {
                CodecUtil.checkFooter(input);
            } else {
                CodecUtil.checkEOF(input);
            }
            SegmentInfo si = new SegmentInfo(dir, version, segment, docCount, isCompoundFile, null, diagnostics, null, Collections.emptyMap());
            si.setFiles(files);
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    @Override
    public void write(Directory dir, SegmentInfo info, IOContext ioContext) throws IOException {
        throw new UnsupportedOperationException("this codec can only be used for reading");
    }
}

