/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ExactPhraseScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SloppyPhraseScorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;

public class PhraseQuery
extends Query {
    private final boolean mutable;
    private int slop;
    private String field;
    private final List<Term> terms;
    private final List<Integer> positions;
    private static final int TERM_POSNS_SEEK_OPS_PER_DOC = 128;
    private static final int TERM_OPS_PER_POS = 7;

    private PhraseQuery(int slop, Term[] terms, int[] positions) {
        if (terms.length != positions.length) {
            throw new IllegalArgumentException("Must have as many terms as positions");
        }
        if (slop < 0) {
            throw new IllegalArgumentException("Slop must be >= 0, got " + slop);
        }
        for (int i = 1; i < terms.length; ++i) {
            if (terms[i - 1].field().equals(terms[i].field())) continue;
            throw new IllegalArgumentException("All terms should have the same field");
        }
        for (int position : positions) {
            if (position >= 0) continue;
            throw new IllegalArgumentException("Positions must be >= 0, got " + position);
        }
        for (int i = 1; i < positions.length; ++i) {
            if (positions[i] >= positions[i - 1]) continue;
            throw new IllegalArgumentException("Positions should not go backwards, got " + positions[i - 1] + " before " + positions[i]);
        }
        this.slop = slop;
        this.terms = Arrays.asList(terms);
        this.positions = new ArrayList<Integer>(positions.length);
        for (int pos : positions) {
            this.positions.add(pos);
        }
        this.field = terms.length == 0 ? null : terms[0].field();
        this.mutable = false;
    }

    private static int[] incrementalPositions(int length) {
        int[] positions = new int[length];
        for (int i = 0; i < length; ++i) {
            positions[i] = i;
        }
        return positions;
    }

    private static Term[] toTerms(String field, String ... termStrings) {
        Term[] terms = new Term[termStrings.length];
        for (int i = 0; i < terms.length; ++i) {
            terms[i] = new Term(field, termStrings[i]);
        }
        return terms;
    }

    private static Term[] toTerms(String field, BytesRef ... termBytes) {
        Term[] terms = new Term[termBytes.length];
        for (int i = 0; i < terms.length; ++i) {
            terms[i] = new Term(field, termBytes[i]);
        }
        return terms;
    }

    public PhraseQuery(int slop, String field, String ... terms) {
        this(slop, PhraseQuery.toTerms(field, terms), PhraseQuery.incrementalPositions(terms.length));
    }

    public PhraseQuery(String field, String ... terms) {
        this(0, field, terms);
    }

    public PhraseQuery(int slop, String field, BytesRef ... terms) {
        this(slop, PhraseQuery.toTerms(field, terms), PhraseQuery.incrementalPositions(terms.length));
    }

    public PhraseQuery(String field, BytesRef ... terms) {
        this(0, field, terms);
    }

    public int getSlop() {
        return this.slop;
    }

    public Term[] getTerms() {
        return this.terms.toArray(new Term[0]);
    }

    public int[] getPositions() {
        int[] result = new int[this.positions.size()];
        for (int i = 0; i < this.positions.size(); ++i) {
            result[i] = this.positions.get(i);
        }
        return result;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.terms.isEmpty()) {
            MatchNoDocsQuery rewritten = new MatchNoDocsQuery();
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        if (this.terms.size() == 1) {
            TermQuery tq = new TermQuery(this.terms.get(0));
            tq.setBoost(this.getBoost());
            return tq;
        }
        if (this.positions.get(0) != 0) {
            int[] oldPositions = this.getPositions();
            int[] newPositions = new int[oldPositions.length];
            for (int i = 0; i < oldPositions.length; ++i) {
                newPositions[i] = oldPositions[i] - oldPositions[0];
            }
            PhraseQuery rewritten = new PhraseQuery(this.slop, this.getTerms(), newPositions);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return super.rewrite(reader);
    }

    static float termPositionsCost(TermsEnum termsEnum) throws IOException {
        int docFreq = termsEnum.docFreq();
        assert (docFreq > 0);
        long totalTermFreq = termsEnum.totalTermFreq();
        float expOccurrencesInMatchingDoc = totalTermFreq < (long)docFreq ? 1.0f : (float)totalTermFreq / (float)docFreq;
        return 128.0f + expOccurrencesInMatchingDoc * 7.0f;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new PhraseWeight(searcher, needsScores);
    }

    @Override
    public String toString(String f) {
        int i;
        Term[] terms = this.getTerms();
        int[] positions = this.getPositions();
        StringBuilder buffer = new StringBuilder();
        if (this.field != null && !this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        int maxPosition = positions.length == 0 ? -1 : positions[positions.length - 1];
        String[] pieces = new String[maxPosition + 1];
        for (i = 0; i < terms.length; ++i) {
            int pos = positions[i];
            String s2 = pieces[pos];
            s2 = s2 == null ? terms[i].text() : s2 + "|" + terms[i].text();
            pieces[pos] = s2;
        }
        for (i = 0; i < pieces.length; ++i) {
            String s3;
            if (i > 0) {
                buffer.append(' ');
            }
            if ((s3 = pieces[i]) == null) {
                buffer.append('?');
                continue;
            }
            buffer.append(s3);
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        PhraseQuery that = (PhraseQuery)o;
        return this.slop == that.slop && this.terms.equals(that.terms) && this.positions.equals(that.positions);
    }

    @Override
    public int hashCode() {
        int h2 = super.hashCode();
        h2 = 31 * h2 + this.slop;
        h2 = 31 * h2 + this.terms.hashCode();
        h2 = 31 * h2 + this.positions.hashCode();
        return h2;
    }

    @Deprecated
    public PhraseQuery() {
        this.terms = new ArrayList<Term>();
        this.positions = new ArrayList<Integer>();
        this.mutable = true;
    }

    private void ensureMutable(String method) {
        if (!this.mutable) {
            throw new IllegalStateException("This PhraseQuery has been created with the new PhraseQuery.Builder API. It must not be modified afterwards. The " + method + " method only exists for backward compatibility");
        }
    }

    @Deprecated
    public void setSlop(int s2) {
        this.ensureMutable("setSlop");
        if (s2 < 0) {
            throw new IllegalArgumentException("slop value cannot be negative");
        }
        this.slop = s2;
    }

    @Deprecated
    public void add(Term term) {
        int position = 0;
        if (this.positions.size() > 0) {
            position = this.positions.get(this.positions.size() - 1) + 1;
        }
        this.add(term, position);
    }

    @Deprecated
    public void add(Term term, int position) {
        this.ensureMutable("add");
        Objects.requireNonNull(term, "Term must not be null");
        if (this.positions.size() > 0) {
            int previousPosition = this.positions.get(this.positions.size() - 1);
            if (position < previousPosition) {
                throw new IllegalArgumentException("Positions must be added in order. Got position=" + position + " while previous position was " + previousPosition);
            }
        } else if (position < 0) {
            throw new IllegalArgumentException("Positions must be positive, got " + position);
        }
        if (this.terms.size() == 0) {
            this.field = term.field();
        } else if (!term.field().equals(this.field)) {
            throw new IllegalArgumentException("All phrase terms must be in the same field: " + term);
        }
        this.terms.add(term);
        this.positions.add(position);
    }

    private class PhraseWeight
    extends Weight {
        private final Similarity similarity;
        private final Similarity.SimWeight stats;
        private final boolean needsScores;
        private transient TermContext[] states;
        private final Term[] terms;
        private final int[] positions;

        public PhraseWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            super(PhraseQuery.this);
            this.terms = PhraseQuery.this.getTerms();
            this.positions = PhraseQuery.this.getPositions();
            int[] positions = PhraseQuery.this.getPositions();
            if (positions.length < 2) {
                throw new IllegalStateException("PhraseWeight does not support less than 2 terms, call rewrite first");
            }
            if (positions[0] != 0) {
                throw new IllegalStateException("PhraseWeight requires that the first position is 0, call rewrite first");
            }
            this.needsScores = needsScores;
            this.similarity = searcher.getSimilarity(needsScores);
            IndexReaderContext context = searcher.getTopReaderContext();
            this.states = new TermContext[this.terms.length];
            TermStatistics[] termStats = new TermStatistics[this.terms.length];
            for (int i = 0; i < this.terms.length; ++i) {
                Term term = this.terms[i];
                this.states[i] = TermContext.build(context, term);
                termStats[i] = searcher.termStatistics(term, this.states[i]);
            }
            this.stats = this.similarity.computeWeight(searcher.collectionStatistics(PhraseQuery.this.field), termStats);
        }

        @Override
        public void extractTerms(Set<Term> queryTerms) {
            Collections.addAll(queryTerms, this.terms);
        }

        public String toString() {
            return "weight(" + PhraseQuery.this + ")";
        }

        @Override
        public float getValueForNormalization() {
            return this.stats.getValueForNormalization();
        }

        @Override
        public void normalize(float queryNorm, float boost) {
            this.stats.normalize(queryNorm, boost);
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            assert (this.terms.length > 0);
            LeafReader reader = context.reader();
            Comparable[] postingsFreqs = new PostingsAndFreq[this.terms.length];
            Terms fieldTerms = reader.terms(PhraseQuery.this.field);
            if (fieldTerms == null) {
                return null;
            }
            if (!fieldTerms.hasPositions()) {
                throw new IllegalStateException("field \"" + PhraseQuery.this.field + "\" was indexed without position data; cannot run PhraseQuery (phrase=" + this.getQuery() + ")");
            }
            TermsEnum te = fieldTerms.iterator();
            float totalMatchCost = 0.0f;
            for (int i = 0; i < this.terms.length; ++i) {
                Term t2 = this.terms[i];
                TermState state = this.states[i].get(context.ord);
                if (state == null) {
                    assert (this.termNotInReader(reader, t2)) : "no termstate found but term exists in reader";
                    return null;
                }
                te.seekExact(t2.bytes(), state);
                PostingsEnum postingsEnum = te.postings(null, 24);
                postingsFreqs[i] = new PostingsAndFreq(postingsEnum, this.positions[i], t2);
                totalMatchCost += PhraseQuery.termPositionsCost(te);
            }
            if (PhraseQuery.this.slop == 0) {
                ArrayUtil.timSort((Comparable[])postingsFreqs);
            }
            if (PhraseQuery.this.slop == 0) {
                return new ExactPhraseScorer(this, (PostingsAndFreq[])postingsFreqs, this.similarity.simScorer(this.stats, context), this.needsScores, totalMatchCost);
            }
            return new SloppyPhraseScorer(this, (PostingsAndFreq[])postingsFreqs, PhraseQuery.this.slop, this.similarity.simScorer(this.stats, context), this.needsScores, totalMatchCost);
        }

        private boolean termNotInReader(LeafReader reader, Term term) throws IOException {
            return reader.docFreq(term) == 0;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            Scorer scorer = this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq = PhraseQuery.this.slop == 0 ? (float)scorer.freq() : ((SloppyPhraseScorer)scorer).sloppyFreq();
                Similarity.SimScorer docScorer = this.similarity.simScorer(this.stats, context);
                Explanation freqExplanation = Explanation.match(freq, "phraseFreq=" + freq, new Explanation[0]);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
            }
            return Explanation.noMatch("no matching term", new Explanation[0]);
        }
    }

    static class PostingsAndFreq
    implements Comparable<PostingsAndFreq> {
        final PostingsEnum postings;
        final int position;
        final Term[] terms;
        final int nTerms;

        public PostingsAndFreq(PostingsEnum postings, int position, Term ... terms) {
            this.postings = postings;
            this.position = position;
            int n = this.nTerms = terms == null ? 0 : terms.length;
            if (this.nTerms > 0) {
                if (terms.length == 1) {
                    this.terms = terms;
                } else {
                    Object[] terms2 = new Term[terms.length];
                    System.arraycopy(terms, 0, terms2, 0, terms.length);
                    Arrays.sort(terms2);
                    this.terms = terms2;
                }
            } else {
                this.terms = null;
            }
        }

        @Override
        public int compareTo(PostingsAndFreq other) {
            if (this.position != other.position) {
                return this.position - other.position;
            }
            if (this.nTerms != other.nTerms) {
                return this.nTerms - other.nTerms;
            }
            if (this.nTerms == 0) {
                return 0;
            }
            for (int i = 0; i < this.terms.length; ++i) {
                int res = this.terms[i].compareTo(other.terms[i]);
                if (res == 0) continue;
                return res;
            }
            return 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.position;
            for (int i = 0; i < this.nTerms; ++i) {
                result = 31 * result + this.terms[i].hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PostingsAndFreq other = (PostingsAndFreq)obj;
            if (this.position != other.position) {
                return false;
            }
            if (this.terms == null) {
                return other.terms == null;
            }
            return Arrays.equals(this.terms, other.terms);
        }
    }

    public static class Builder {
        private int slop = 0;
        private final List<Term> terms = new ArrayList<Term>();
        private final List<Integer> positions = new ArrayList<Integer>();

        public Builder setSlop(int slop) {
            this.slop = slop;
            return this;
        }

        public Builder add(Term term) {
            return this.add(term, this.positions.isEmpty() ? 0 : 1 + this.positions.get(this.positions.size() - 1));
        }

        public Builder add(Term term, int position) {
            int lastPosition;
            if (position < 0) {
                throw new IllegalArgumentException("Positions must be >= 0, got " + position);
            }
            if (!this.positions.isEmpty() && position < (lastPosition = this.positions.get(this.positions.size() - 1).intValue())) {
                throw new IllegalArgumentException("Positions must be added in order, got " + position + " after " + lastPosition);
            }
            if (!this.terms.isEmpty() && !term.field().equals(this.terms.get(0).field())) {
                throw new IllegalArgumentException("All terms must be on the same field, got " + term.field() + " and " + this.terms.get(0).field());
            }
            this.terms.add(term);
            this.positions.add(position);
            return this;
        }

        public PhraseQuery build() {
            Term[] terms = this.terms.toArray(new Term[this.terms.size()]);
            int[] positions = new int[this.positions.size()];
            for (int i = 0; i < positions.length; ++i) {
                positions[i] = this.positions.get(i);
            }
            return new PhraseQuery(this.slop, terms, positions);
        }
    }
}

