/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RemoteRuleFallbackManager {
    INSTANCE;

    @Generated
    private static final Logger log;
    private final AtomicBoolean initCalled = new AtomicBoolean(false);
    private final Map<String, RemoteRuleConfig> fallbackConfigs = new ConcurrentHashMap<String, RemoteRuleConfig>();

    public void init(@NotNull File remoteRuleConfigFile) {
        if (!this.initCalled.compareAndSet(false, true)) {
            return;
        }
        List<RemoteRuleConfig> config = null;
        try {
            config = RemoteRuleConfig.load(remoteRuleConfigFile);
        }
        catch (ExecutionException e) {
            log.error("Could not load remote rule configuration at {}", (Object)remoteRuleConfigFile.getAbsolutePath(), (Object)e);
        }
        if (config != null) {
            this.setup(config);
        } else {
            this.initCalled.set(false);
        }
    }

    public void init_for_tests_only(@NotNull List<RemoteRuleConfig> config) {
        this.fallbackConfigs.clear();
        this.initCalled.set(true);
        this.setup(config);
    }

    private void setup(@NotNull List<RemoteRuleConfig> finalConfig) {
        finalConfig.forEach(remoteRuleConfig -> {
            String fallbackRuleId = remoteRuleConfig.getFallbackRuleId();
            log.info("Found remote rule {} with fallback rule {}", (Object)remoteRuleConfig.ruleId, (Object)fallbackRuleId);
            if (fallbackRuleId != null && !fallbackRuleId.isEmpty()) {
                List<RemoteRuleConfig> fallbackRulesFor = finalConfig.stream().filter(rc -> rc.getRuleId().equals(fallbackRuleId)).toList();
                if (fallbackRulesFor.size() != 1) {
                    log.warn("Fallback rule {} for remote rule {} not found or not unique, skipping fallback configuration.", (Object)fallbackRuleId, (Object)remoteRuleConfig.ruleId);
                } else {
                    this.fallbackConfigs.put(remoteRuleConfig.ruleId, fallbackRulesFor.get(0));
                }
            }
        });
        log.info("Loaded {} fallback rules: {}", (Object)this.fallbackConfigs.size(), (Object)this.fallbackConfigs.keySet());
    }

    @Nullable
    public RemoteRuleConfig getInhouseFallback(@NotNull String ruleId) {
        if (!this.initCalled.get()) {
            log.warn("RemoteRuleFallbackManager not initialized cannot find fallback for rule {}", (Object)ruleId);
            return null;
        }
        if (this.fallbackConfigs.isEmpty()) {
            log.warn("No fallback rules configured, cannot find fallback for rule {}", (Object)ruleId);
            return null;
        }
        RemoteRuleConfig fallbackConfig = this.fallbackConfigs.get(ruleId);
        if (fallbackConfig == null || fallbackConfig.isUsingThirdPartyAI()) {
            log.warn("No fallback rule configured for rule {}, or it is a 3rd party rule, cannot find fallback.", (Object)ruleId);
            return null;
        }
        return fallbackConfig;
    }

    @Nullable
    public String isRuleOrFallbackAvailable(@NotNull RemoteRule rule, @NotNull Map<String, RemoteRule> remoteRules) {
        return this.isRuleOrFallbackAvailable(rule, remoteRules, new HashSet<String>());
    }

    @Nullable
    private String isRuleOrFallbackAvailable(@NotNull RemoteRule rule, @NotNull Map<String, RemoteRule> remoteRules, Set<String> visited) {
        boolean isOpen;
        if (!visited.add(rule.getId())) {
            log.warn("Circular fallback chain detected for rule {}", (Object)rule.getId());
            return null;
        }
        boolean bl = isOpen = rule.circuitBreaker().getState() == CircuitBreaker.State.OPEN;
        if (isOpen) {
            RemoteRule fallbackRule;
            String fallbackRuleId = rule.getServiceConfiguration().getFallbackRuleId();
            if (fallbackRuleId != null && !fallbackRuleId.isEmpty() && (fallbackRule = remoteRules.get(fallbackRuleId)) != null) {
                return this.isRuleOrFallbackAvailable(fallbackRule, remoteRules, visited);
            }
            return null;
        }
        return rule.getId();
    }

    static {
        log = LoggerFactory.getLogger(RemoteRuleFallbackManager.class);
    }
}

