/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.language.Catalan;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ca.CatalanSynthesizer;

public class BalearicCatalan
extends Catalan {
    private static final String LANGUAGE_SHORT_CODE = "ca-ES-balear";
    private static volatile Throwable instantiationTraceBalear;

    public BalearicCatalan() {
        super(true);
        Throwable trace = instantiationTraceBalear;
        if (trace != null) {
            throw new RuntimeException("Language was already instantiated, see the cause stacktrace below.", trace);
        }
        instantiationTraceBalear = new Throwable();
    }

    @NotNull
    public static BalearicCatalan getInstance() {
        Language language = Objects.requireNonNull(Languages.getLanguageForShortCode(LANGUAGE_SHORT_CODE));
        if (language instanceof BalearicCatalan) {
            BalearicCatalan catalan = (BalearicCatalan)language;
            return catalan;
        }
        throw new RuntimeException("BalearicCatalan language expected, got " + language);
    }

    @Override
    public String getName() {
        return "Catalan (Balearic)";
    }

    @Override
    public String[] getCountries() {
        return new String[]{"ES"};
    }

    @Override
    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return CatalanSynthesizer.INSTANCE_BAL;
    }

    @Override
    public String getVariant() {
        return "balear";
    }

    @Override
    public List<String> getDefaultEnabledRulesForVariant() {
        List<String> rules = Arrays.asList("EXIGEIX_VERBS_BALEARS");
        return Collections.unmodifiableList(rules);
    }

    @Override
    public List<String> getDefaultDisabledRulesForVariant() {
        List<String> rules = Arrays.asList("EXIGEIX_VERBS_CENTRAL", "CA_SIMPLE_REPLACE_BALEARIC");
        return Collections.unmodifiableList(rules);
    }
}

