/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.FSDirectory;
import org.languagetool.Experimental;
import org.languagetool.languagemodel.BaseLanguageModel;

public class LuceneSingleIndexLanguageModel
extends BaseLanguageModel {
    private static final Map<File, LuceneSearcher> dirToSearcherMap = new HashMap<File, LuceneSearcher>();
    private final List<File> indexes = new ArrayList<File>();
    private final Map<Integer, LuceneSearcher> luceneSearcherMap = new HashMap<Integer, LuceneSearcher>();
    private final File topIndexDir;
    private final long maxNgram;

    public static void validateDirectory(File topIndexDir) {
        if (!topIndexDir.exists() || !topIndexDir.isDirectory()) {
            throw new RuntimeException("Not found or is not a directory:\n" + topIndexDir + "\nAs ngram directory, please select the directory that has a subdirectory like 'en'\n(or whatever language code you're using).");
        }
        ArrayList<String> dirs = new ArrayList<String>();
        for (String name : topIndexDir.list()) {
            if (!name.matches("[123]grams")) continue;
            dirs.add(name);
        }
        if (dirs.isEmpty()) {
            throw new RuntimeException("Directory must contain at least '1grams', '2grams', and '3grams': " + topIndexDir.getAbsolutePath());
        }
        if (dirs.size() < 3) {
            throw new RuntimeException("Expected at least '1grams', '2grams', and '3grams' sub directories but only got " + dirs + " in " + topIndexDir.getAbsolutePath());
        }
    }

    @Experimental
    public static void clearCaches() {
        dirToSearcherMap.clear();
    }

    public LuceneSingleIndexLanguageModel(File topIndexDir) {
        this.doValidateDirectory(topIndexDir);
        this.topIndexDir = topIndexDir;
        this.addIndex(topIndexDir, 1);
        this.addIndex(topIndexDir, 2);
        this.addIndex(topIndexDir, 3);
        this.addIndex(topIndexDir, 4);
        if (this.luceneSearcherMap.isEmpty()) {
            throw new RuntimeException("No directories '1grams' ... '3grams' found in " + topIndexDir);
        }
        this.maxNgram = Collections.max(this.luceneSearcherMap.keySet()).intValue();
    }

    public LuceneSingleIndexLanguageModel(int maxNgram) {
        this.maxNgram = maxNgram;
        this.topIndexDir = null;
    }

    protected void doValidateDirectory(File topIndexDir) {
        LuceneSingleIndexLanguageModel.validateDirectory(topIndexDir);
    }

    private void addIndex(File topIndexDir, int ngramSize) {
        File indexDir = new File(topIndexDir, ngramSize + "grams");
        if (indexDir.exists() && indexDir.isDirectory()) {
            if (this.luceneSearcherMap.containsKey(ngramSize)) {
                throw new RuntimeException("Searcher for ngram size " + ngramSize + " already exists");
            }
            this.luceneSearcherMap.put(ngramSize, this.getCachedLuceneSearcher(indexDir));
            this.indexes.add(indexDir);
        }
    }

    @Override
    public long getCount(List<String> tokens) {
        if ((long)tokens.size() > this.maxNgram) {
            throw new RuntimeException("Requested " + tokens.size() + "gram but index has only up to " + this.maxNgram + "gram: " + tokens);
        }
        Objects.requireNonNull(tokens);
        Term term = new Term("ngram", String.join((CharSequence)" ", tokens));
        return this.getCount(term, this.getLuceneSearcher(tokens.size()));
    }

    @Override
    public long getCount(String token1) {
        Objects.requireNonNull(token1);
        return this.getCount(Arrays.asList(token1));
    }

    @Override
    public long getTotalTokenCount() {
        LuceneSearcher luceneSearcher = this.getLuceneSearcher(1);
        try {
            RegexpQuery query = new RegexpQuery(new Term("totalTokenCount", ".*"));
            TopDocs docs = luceneSearcher.searcher.search((Query)query, 1000);
            if (docs.totalHits == 0) {
                throw new RuntimeException("Expected 'totalTokenCount' meta documents not found in 1grams index: " + luceneSearcher.directory);
            }
            if (docs.totalHits > 1000) {
                throw new RuntimeException("Did not expect more than 1000 'totalTokenCount' meta documents: " + docs.totalHits + " in " + luceneSearcher.directory);
            }
            long result = 0L;
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                long tmp = Long.parseLong(luceneSearcher.reader.document(scoreDoc.doc).get("totalTokenCount"));
                if (tmp <= result) continue;
                result = tmp;
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected LuceneSearcher getLuceneSearcher(int ngramSize) {
        LuceneSearcher luceneSearcher = this.luceneSearcherMap.get(ngramSize);
        if (luceneSearcher == null) {
            throw new RuntimeException("No " + ngramSize + "grams directory found in " + this.topIndexDir);
        }
        return luceneSearcher;
    }

    private LuceneSearcher getCachedLuceneSearcher(File indexDir) {
        LuceneSearcher luceneSearcher = dirToSearcherMap.get(indexDir);
        if (luceneSearcher == null) {
            try {
                LuceneSearcher newSearcher = new LuceneSearcher(indexDir);
                dirToSearcherMap.put(indexDir, newSearcher);
                return newSearcher;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return luceneSearcher;
    }

    private long getCount(Term term, LuceneSearcher luceneSearcher) {
        long result = 0L;
        try {
            TopDocs docs = luceneSearcher.searcher.search((Query)new TermQuery(term), 2000);
            if (docs.totalHits > 2000) {
                throw new RuntimeException("More than 2000 matches for '" + term + "' not supported for performance reasons: " + docs.totalHits + " matches in " + luceneSearcher.directory);
            }
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                String countStr = luceneSearcher.reader.document(scoreDoc.doc).get("count");
                result += Long.parseLong(countStr);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public void close() {
        for (LuceneSearcher searcher : this.luceneSearcherMap.values()) {
            try {
                searcher.reader.close();
                searcher.directory.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return this.indexes.toString();
    }

    protected static class LuceneSearcher {
        final FSDirectory directory;
        final IndexReader reader;
        final IndexSearcher searcher;

        private LuceneSearcher(File indexDir) throws IOException {
            Path path = indexDir.toPath();
            if (Files.isSymbolicLink(path)) {
                path = indexDir.getCanonicalFile().toPath();
            }
            this.directory = FSDirectory.open(path);
            this.reader = DirectoryReader.open(this.directory);
            this.searcher = new IndexSearcher(this.reader);
        }

        public IndexReader getReader() {
            return this.reader;
        }
    }
}

