/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.CachingWordListLoader;
import org.languagetool.tools.StringTools;

public abstract class AbstractSpecificCaseRule
extends Rule {
    private static final ConcurrentMap<Class, Map<String, String>> lcToProperSpelling = new ConcurrentHashMap<Class, Map<String, String>>();
    private static int maxLen;
    protected final CachingWordListLoader phrasesListLoader = new CachingWordListLoader();

    public AbstractSpecificCaseRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.CASING.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.loadPhrases();
    }

    public abstract String getPhrasesPath();

    public String getInitialCapitalMessage() {
        return "The initials of the particular phrase must be capitals.";
    }

    public String getOtherCapitalizationMessage() {
        return "The particular expression should follow the suggested capitalization.";
    }

    public String getShortMessage() {
        return "Special capitalization";
    }

    private synchronized void loadPhrases() {
        lcToProperSpelling.computeIfAbsent(this.getClass(), clazz -> {
            Object2ObjectOpenHashMap<String, String> properSpelling = new Object2ObjectOpenHashMap<String, String>();
            List<String> lines = this.phrasesListLoader.loadWords(this.getPhrasesPath());
            for (String line : lines) {
                int parts = line.split(" ").length;
                maxLen = Math.max(parts, maxLen);
                String phrase = line.trim();
                properSpelling.put(phrase.toLowerCase(), phrase);
            }
            return properSpelling;
        });
    }

    @Override
    public String getId() {
        return "SPECIFIC_CASE";
    }

    @Override
    public String getDescription() {
        return "Checks upper/lower case expressions.";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        Map properSpellingMap = (Map)lcToProperSpelling.get(this.getClass());
        for (int i = 0; i < tokens.length; ++i) {
            ArrayList<String> l = new ArrayList<String>();
            int j = 0;
            while (l.size() < maxLen && i + j < tokens.length) {
                l.add(tokens[i + j].getToken());
                ++j;
                String phrase = String.join((CharSequence)" ", l);
                String lcPhrase = phrase.toLowerCase();
                String properSpelling = (String)properSpellingMap.get(lcPhrase);
                if (properSpelling == null || StringTools.isAllUppercase(phrase) || phrase.equals(properSpelling) || i > 0 && tokens[i - 1].isSentenceStart() && !StringTools.startsWithUppercase(properSpelling)) continue;
                String msg = this.allWordsUppercase(properSpelling) ? this.getInitialCapitalMessage() : this.getOtherCapitalizationMessage();
                RuleMatch match = new RuleMatch(this, sentence, tokens[i].getStartPos(), tokens[i + j - 1].getEndPos(), msg, this.getShortMessage());
                match.setSuggestedReplacement(properSpelling);
                matches.add(match);
            }
        }
        return this.toRuleMatchArray(matches);
    }

    private boolean allWordsUppercase(String s2) {
        return Arrays.stream(s2.split(" ")).allMatch(StringTools::startsWithUppercase);
    }
}

