/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tagging.Tagger;

public abstract class AbstractSuppressMisspelledSuggestionsFilter
extends RuleFilter {
    protected AbstractSuppressMisspelledSuggestionsFilter() {
    }

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        RuleMatch ruleMatch = match;
        Language language = ((PatternRule)match.getRule()).getLanguage();
        Tagger tagger = language.getTagger();
        List<String> replacements = match.getSuggestedReplacements();
        ArrayList<String> newReplacements = new ArrayList<String>();
        String suppressMatch = this.getRequired("suppressMatch", arguments);
        String suppressPostag = this.getOptional("SuppressPostag", arguments);
        List<Object> atrs = new ArrayList();
        if (tagger != null && suppressPostag != null) {
            atrs = tagger.tag(replacements);
        }
        for (int i = 0; i < replacements.size(); ++i) {
            if (this.isMisspelled(replacements.get(i), language)) continue;
            if (tagger != null && suppressPostag != null) {
                if (((AnalyzedTokenReadings)atrs.get(i)).matchesPosTagRegex(suppressPostag)) continue;
                newReplacements.add(replacements.get(i));
                continue;
            }
            newReplacements.add(replacements.get(i));
        }
        boolean bSuppressMatch = true;
        if (suppressMatch != null && suppressMatch.equalsIgnoreCase("false")) {
            bSuppressMatch = false;
        }
        if (newReplacements.isEmpty() && bSuppressMatch) {
            return null;
        }
        ruleMatch.setSuggestedReplacements(newReplacements);
        return ruleMatch;
    }

    public boolean isMisspelled(String s2, Language language) throws IOException {
        SpellingCheckRule spellerRule = language.getDefaultSpellingRule();
        if (spellerRule == null) {
            return false;
        }
        List<String> tokens = language.getWordTokenizer().tokenize(s2);
        for (String token : tokens) {
            if (!spellerRule.isMisspelled(token)) continue;
            return true;
        }
        return false;
    }
}

