/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import lombok.Generated;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Premium;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.ml.MLServerProto;
import org.languagetool.tools.grpc.ProtoHelper;
import org.languagetool.tools.grpc.RuleData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GRPCUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GRPCUtils.class);

    public static MLServerProto.AnalyzedToken toGRPC(AnalyzedToken token) {
        MLServerProto.AnalyzedToken.Builder t2 = MLServerProto.AnalyzedToken.newBuilder();
        if (token.getLemma() != null) {
            t2.setLemma(token.getLemma());
        }
        if (token.getPOSTag() != null) {
            t2.setPosTag(token.getPOSTag());
        }
        t2.setToken(token.getToken());
        return t2.build();
    }

    public static MLServerProto.AnalyzedTokenReadings toGRPC(AnalyzedTokenReadings readings) {
        return MLServerProto.AnalyzedTokenReadings.newBuilder().addAllChunkTags(readings.getChunkTags().stream().map(ChunkTag::getChunkTag).toList()).addAllReadings(readings.getReadings().stream().map(GRPCUtils::toGRPC).toList()).build();
    }

    public static MLServerProto.AnalyzedSentence toGRPC(AnalyzedSentence sentence) {
        return MLServerProto.AnalyzedSentence.newBuilder().setText(sentence.getText()).addAllTokens(Arrays.stream(sentence.getTokens()).map(GRPCUtils::toGRPC).toList()).build();
    }

    public static AnalyzedTokenReadings fromGRPC(MLServerProto.AnalyzedTokenReadings tokenReadings) {
        return new AnalyzedTokenReadings(tokenReadings.getReadingsList().stream().map(GRPCUtils::fromGRPC).toList(), tokenReadings.getStartPos());
    }

    public static AnalyzedToken fromGRPC(MLServerProto.AnalyzedToken token) {
        return new AnalyzedToken(token.getToken(), token.getPosTag(), token.getLemma());
    }

    public static AnalyzedSentence fromGRPC(MLServerProto.AnalyzedSentence sentence) {
        return new AnalyzedSentence((AnalyzedTokenReadings[])sentence.getTokensList().stream().map(GRPCUtils::fromGRPC).toArray(AnalyzedTokenReadings[]::new));
    }

    public static MLServerProto.Match toGRPC(RuleMatch m4) {
        return MLServerProto.Match.newBuilder().setOffset(m4.getFromPos()).setLength(m4.getToPos() - m4.getFromPos()).setId(m4.getSpecificRuleId()).setSubId(ProtoHelper.nullAsEmpty(m4.getRule().getSubId())).addAllSuggestedReplacements(m4.getSuggestedReplacementObjects().stream().map(GRPCUtils::toGRPC).toList()).setRuleDescription(ProtoHelper.nullAsEmpty(m4.getRule().getDescription())).setMatchDescription(ProtoHelper.nullAsEmpty(m4.getMessage())).setMatchShortDescription(ProtoHelper.nullAsEmpty(m4.getShortMessage())).setUrl(ProtoHelper.getUrl(m4)).setAutoCorrect(m4.isAutoCorrect()).setType(MLServerProto.Match.MatchType.valueOf(m4.getType().name())).setContextForSureMatch(m4.getRule().estimateContextForSureMatch()).setRule(MLServerProto.Rule.newBuilder().setSourceFile(ProtoHelper.nullAsEmpty(m4.getRule().getSourceFile())).setIssueType(m4.getRule().getLocQualityIssueType().name()).setTempOff(m4.getRule().isDefaultTempOff()).setCategory(MLServerProto.RuleCategory.newBuilder().setId(m4.getRule().getCategory().getId().toString()).setName(m4.getRule().getCategory().getName()).build()).setIsPremium(Premium.get().isPremiumRule(m4.getRule())).addAllTags(m4.getRule().getTags().stream().map(t2 -> MLServerProto.Rule.Tag.valueOf(t2.name())).toList()).build()).build();
    }

    public static RuleMatch fromGRPC(MLServerProto.Match m4, AnalyzedSentence s2) {
        RuleData rule = new RuleData(m4);
        RuleMatch r = new RuleMatch(rule, s2, m4.getOffset(), m4.getOffset() + m4.getLength(), m4.getMatchDescription(), m4.getMatchShortDescription());
        r.setSuggestedReplacementObjects(m4.getSuggestedReplacementsList().stream().map(GRPCUtils::fromGRPC).toList());
        r.setAutoCorrect(m4.getAutoCorrect());
        r.setType(RuleMatch.Type.valueOf(m4.getType().name()));
        if (!m4.getUrl().isEmpty()) {
            try {
                r.setUrl(new URL(m4.getUrl()));
            }
            catch (MalformedURLException e) {
                log.warn("Got invalid URL from GRPC match filter: {}", e);
            }
        }
        return r;
    }

    public static MLServerProto.SuggestedReplacement toGRPC(SuggestedReplacement s2) {
        MLServerProto.SuggestedReplacement.Builder sb = MLServerProto.SuggestedReplacement.newBuilder().setReplacement(s2.getReplacement()).setDescription(ProtoHelper.nullAsEmpty(s2.getShortDescription())).setSuffix(ProtoHelper.nullAsEmpty(s2.getSuffix())).setType(MLServerProto.SuggestedReplacement.SuggestionType.valueOf(s2.getType().name()));
        if (s2.getConfidence() != null) {
            sb.setConfidence(s2.getConfidence().floatValue());
        }
        return sb.build();
    }

    public static SuggestedReplacement fromGRPC(MLServerProto.SuggestedReplacement s2) {
        SuggestedReplacement sb = new SuggestedReplacement(s2.getReplacement(), ProtoHelper.emptyAsNull(s2.getDescription()), ProtoHelper.emptyAsNull(s2.getSuffix()));
        sb.setType(SuggestedReplacement.SuggestionType.valueOf(s2.getType().name()));
        if (s2.getConfidence() != 0.0f) {
            sb.setConfidence(Float.valueOf(s2.getConfidence()));
        }
        return sb;
    }

    public static JLanguageTool.Level fromGRPC(MLServerProto.ProcessingOptions.Level l) {
        if (l.equals(MLServerProto.ProcessingOptions.Level.defaultLevel)) {
            return JLanguageTool.Level.DEFAULT;
        }
        return JLanguageTool.Level.valueOf(l.name().toUpperCase());
    }

    public static MLServerProto.ProcessingOptions.Level toGRPC(JLanguageTool.Level level) {
        if (level.equals((Object)JLanguageTool.Level.DEFAULT)) {
            return MLServerProto.ProcessingOptions.Level.defaultLevel;
        }
        return MLServerProto.ProcessingOptions.Level.valueOf(level.name().toLowerCase());
    }
}

