/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.languagetool.Language;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RemoteRuleConfig {
    private static final int DEFAULT_PORT = 443;
    private static final long DEFAULT_BASE_TIMEOUT = 1000L;
    private static final float DEFAULT_TIMEOUT_PER_CHAR = 0.0f;
    private static final long DEFAULT_DOWN = 5000L;
    private static final float DEFAULT_FAILURE_RATE_THRESHOLD = 50.0f;
    private static final String DEFAULT_SLIDING_WINDOW_TYPE = CircuitBreakerConfig.SlidingWindowType.TIME_BASED.name();
    private static final int DEFAULT_SLIDING_WINDOW_SIZE = 60;
    private static final int DEFAULT_MINIMUM_NUMBER_OF_CALLS = 10;
    public static final String THIRD_PARTY_AI = "thirdPartyAI";
    public static final String FALLBACK_RULE_ID = "fallbackRuleId";
    public static final String PREMIUM = "premium";
    private static final LoadingCache<File, List<RemoteRuleConfig>> configCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build(new CacheLoader<File, List<RemoteRuleConfig>>(){

        @Override
        public List<RemoteRuleConfig> load(File path) throws Exception {
            try (FileInputStream in = new FileInputStream(path);){
                List<RemoteRuleConfig> list = RemoteRuleConfig.parse(in);
                return list;
            }
        }
    });
    public String ruleId;
    public String url;
    public Integer port = 443;
    public long baseTimeoutMilliseconds = 1000L;
    public float timeoutPerCharacterMilliseconds = 0.0f;
    public long downMilliseconds = 5000L;
    public float failureRateThreshold = 50.0f;
    public String slidingWindowType = DEFAULT_SLIDING_WINDOW_TYPE;
    public int slidingWindowSize = 60;
    public int minimumNumberOfCalls = 10;
    public Map<String, String> options = new HashMap<String, String>();
    public String language;
    public String type;

    public RemoteRuleConfig() {
    }

    public RemoteRuleConfig(RemoteRuleConfig copy) {
        this.ruleId = copy.ruleId;
        this.url = copy.url;
        this.port = copy.port;
        this.baseTimeoutMilliseconds = copy.baseTimeoutMilliseconds;
        this.timeoutPerCharacterMilliseconds = copy.timeoutPerCharacterMilliseconds;
        this.downMilliseconds = copy.downMilliseconds;
        this.failureRateThreshold = copy.failureRateThreshold;
        this.slidingWindowType = copy.slidingWindowType;
        this.slidingWindowSize = copy.slidingWindowSize;
        this.minimumNumberOfCalls = copy.minimumNumberOfCalls;
        this.options = new HashMap<String, String>(copy.options);
        this.language = copy.language;
        this.type = copy.type;
    }

    public static RemoteRuleConfig getRelevantConfig(String rule, List<RemoteRuleConfig> configs) {
        return configs.stream().filter(config -> config.getRuleId().equals(rule)).findFirst().orElse(null);
    }

    public static Predicate<RemoteRuleConfig> isRelevantConfig(String type, Language language) {
        return r -> type.equals(r.type) && (r.language == null || language.getShortCodeWithCountryAndVariant().matches(r.language));
    }

    public static List<RemoteRuleConfig> parse(InputStream json) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS));
        return mapper.readValue(json, new TypeReference<List<RemoteRuleConfig>>(){});
    }

    public static List<RemoteRuleConfig> load(File configFile) throws ExecutionException {
        return configCache.get(configFile);
    }

    public float getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    public String getSlidingWindowType() {
        return this.slidingWindowType;
    }

    public int getSlidingWindowSize() {
        return this.slidingWindowSize;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getUrl() {
        return this.url;
    }

    public int getPort() {
        return this.port != null ? this.port : 443;
    }

    public long getDownMilliseconds() {
        return this.downMilliseconds;
    }

    public long getBaseTimeoutMilliseconds() {
        return this.baseTimeoutMilliseconds;
    }

    public float getTimeoutPerCharacterMilliseconds() {
        return this.timeoutPerCharacterMilliseconds;
    }

    public int getMinimumNumberOfCalls() {
        return this.minimumNumberOfCalls;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getType() {
        return this.type;
    }

    public boolean isUsingThirdPartyAI() {
        return this.options.getOrDefault(THIRD_PARTY_AI, "false").equals("true");
    }

    public boolean isPremium() {
        return this.options.getOrDefault(PREMIUM, "false").equals("true");
    }

    public String getFallbackRuleId() {
        return this.options.get(FALLBACK_RULE_ID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteRuleConfig that = (RemoteRuleConfig)o;
        return new EqualsBuilder().append(this.baseTimeoutMilliseconds, that.baseTimeoutMilliseconds).append(this.timeoutPerCharacterMilliseconds, that.timeoutPerCharacterMilliseconds).append(this.downMilliseconds, that.downMilliseconds).append(this.failureRateThreshold, that.failureRateThreshold).append(this.slidingWindowSize, that.slidingWindowSize).append(this.minimumNumberOfCalls, that.minimumNumberOfCalls).append(this.ruleId, that.ruleId).append(this.url, that.url).append(this.port, that.port).append(this.slidingWindowType, that.slidingWindowType).append(this.options, that.options).append(this.language, that.language).append(this.type, that.type).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.ruleId).append(this.url).append(this.port).append(this.baseTimeoutMilliseconds).append(this.timeoutPerCharacterMilliseconds).append(this.downMilliseconds).append(this.failureRateThreshold).append(this.slidingWindowType).append(this.slidingWindowSize).append(this.minimumNumberOfCalls).append(this.options).append(this.language).append(this.type).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("ruleId", this.ruleId).append("url", this.url).append("port", this.port).append("baseTimeoutMilliseconds", this.baseTimeoutMilliseconds).append("timeoutPerCharacterMilliseconds", this.timeoutPerCharacterMilliseconds).append("downMilliseconds", this.downMilliseconds).append("failureRateThreshold", this.failureRateThreshold).append("slidingWindowType", this.slidingWindowType).append("slidingWindowSize", this.slidingWindowSize).append("minimumNumberOfCalls", this.minimumNumberOfCalls).append("options", this.options).append("language", this.language).append("type", this.type).toString();
    }
}

