/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.prometheus.client.Histogram;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteRuleMetrics {
    private static final Logger logger = LoggerFactory.getLogger(RemoteRuleMetrics.class);
    private static final double[] WAIT_BUCKETS = new double[]{0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.75, 1.0, 2.0, 5.0, 7.5, 10.0, 15.0};
    private static final double[] LATENCY_BUCKETS = new double[]{0.025, 0.05, 0.1, 0.25, 0.5, 0.75, 1.0, 2.0, 4.0, 6.0, 8.0, 10.0, 15.0};
    private static final double[] SIZE_BUCKETS = new double[]{25.0, 100.0, 500.0, 1000.0, 2500.0, 5000.0, 10000.0, 20000.0, 40000.0};
    private static final Histogram wait = (Histogram)((Histogram.Builder)Histogram.build("languagetool_remote_rule_wait_seconds", "Time spent waiting on remote rule results/timeouts").labelNames("language")).buckets(WAIT_BUCKETS).register();
    private static final Histogram requestLatency = (Histogram)((Histogram.Builder)Histogram.build("languagetool_remote_rule_request_latency_seconds", "Request duration summary").labelNames("rule_id", "result")).buckets(LATENCY_BUCKETS).register();
    private static final Histogram requestThroughput = (Histogram)((Histogram.Builder)Histogram.build("languagetool_remote_rule_request_throughput_characters", "Request size summary").labelNames("rule_id", "result")).buckets(SIZE_BUCKETS).register();

    private RemoteRuleMetrics() {
        throw new IllegalStateException("RemoteRuleMetrics should only be used via static methods.");
    }

    public static void request(String rule, long startNanos, long characters, RequestResult result) {
        long delta = System.nanoTime() - startNanos;
        ((Histogram.Child)requestLatency.labels(rule, result.name().toLowerCase())).observe((double)delta / 1.0E9);
        ((Histogram.Child)requestThroughput.labels(rule, result.name().toLowerCase())).observe(characters);
    }

    public static void wait(String langCode, long milliseconds) {
        ((Histogram.Child)wait.labels(langCode)).observe((double)milliseconds / 1000.0);
    }

    @ApiStatus.Internal
    @Nullable
    public static <T> T inCircuitBreaker(long deadlineStartNanos, CircuitBreaker circuitBreaker, String ruleKey, long chars, Callable<T> fetchResults) throws InterruptedException {
        try {
            return circuitBreaker.executeCallable(fetchResults);
        }
        catch (InterruptedException e) {
            logger.info("Failed to fetch result from remote rule '{}' - interrupted.", (Object)ruleKey);
            RemoteRuleMetrics.request(ruleKey, deadlineStartNanos, chars, RequestResult.INTERRUPTED);
            throw e;
        }
        catch (CancellationException e) {
            logger.info("Failed to fetch result from remote rule '{}' - cancelled.", (Object)ruleKey);
            RemoteRuleMetrics.request(ruleKey, deadlineStartNanos, chars, RequestResult.INTERRUPTED);
        }
        catch (TimeoutException e) {
            long timeout = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - deadlineStartNanos);
            logger.info("Failed to fetch result from remote rule '{}' - timed out ({}ms, {} chars).", ruleKey, timeout, chars);
            RemoteRuleMetrics.request(ruleKey, deadlineStartNanos, chars, RequestResult.TIMEOUT);
        }
        catch (CallNotPermittedException e) {
            logger.info("Failed to fetch result from remote rule '{}' - circuitbreaker active, rule marked as down.", (Object)ruleKey);
            RemoteRuleMetrics.request(ruleKey, deadlineStartNanos, chars, RequestResult.DOWN);
        }
        catch (Exception e) {
            if (ExceptionUtils.indexOfThrowable(e, TimeoutException.class) != -1) {
                long timeout = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - deadlineStartNanos);
                logger.info("Failed to fetch result from remote rule '{}' - timed out with exception {} ({}ms, {} chars).", ruleKey, e, timeout, chars);
                RemoteRuleMetrics.request(ruleKey, deadlineStartNanos, chars, RequestResult.TIMEOUT);
            }
            logger.warn("Failed to fetch result from remote rule '" + ruleKey + "' - error while executing rule.", e);
            RemoteRuleMetrics.request(ruleKey, deadlineStartNanos, chars, RequestResult.ERROR);
        }
        return null;
    }

    public static enum RequestResult {
        SUCCESS,
        SKIPPED,
        TIMEOUT,
        INTERRUPTED,
        DOWN,
        ERROR;

    }
}

