/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class SentenceWhitespaceRule
extends TextLevelRule {
    public SentenceWhitespaceRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.TYPOGRAPHY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Whitespace);
    }

    @Override
    public String getId() {
        return "SENTENCE_WHITESPACE";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("missing_space_between_sentences");
    }

    public String getMessage(boolean prevSentenceEndsWithNumber) {
        return this.messages.getString("addSpaceBetweenSentences");
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        boolean isFirstSentence = true;
        boolean prevSentenceEndsWithWhitespace = false;
        boolean prevSentenceEndsWithNumber = false;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokens();
            if (isFirstSentence) {
                isFirstSentence = false;
            } else if (!prevSentenceEndsWithWhitespace && tokens.length > 1) {
                String firstToken = tokens[1].getToken();
                RuleMatch ruleMatch = new RuleMatch(this, sentence, pos, pos + firstToken.length(), this.getMessage(prevSentenceEndsWithNumber));
                ruleMatch.setSuggestedReplacement(" " + firstToken);
                ruleMatches.add(ruleMatch);
            }
            if (tokens.length > 0) {
                String lastToken = tokens[tokens.length - 1].getToken();
                boolean bl = prevSentenceEndsWithWhitespace = lastToken.replace('\u00a0', ' ').trim().isEmpty() && lastToken.length() == 1;
            }
            if (tokens.length > 1) {
                String prevLastToken = tokens[tokens.length - 2].getToken();
                prevSentenceEndsWithNumber = StringUtils.isNumeric(prevLastToken);
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

