/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryIds;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SpecificIdRule;
import org.languagetool.tools.StringTools;

public abstract class WrongWordInContextRule
extends Rule {
    private static final LoadingCache<String, List<ContextWords>> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build(new CacheLoader<String, List<ContextWords>>(){

        @Override
        public List<ContextWords> load(@NotNull String path) {
            return WrongWordInContextRule.loadContextWords(path);
        }
    });
    private final List<ContextWords> contextWordsSet;
    private final Language lang;
    private boolean matchLemmas = false;

    public WrongWordInContextRule(ResourceBundle messages, Language lang) {
        super.setCategory(new Category(CategoryIds.CONFUSED_WORDS, this.getCategoryString()));
        this.contextWordsSet = cache.getUnchecked(this.getFilename());
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.lang = lang;
    }

    protected abstract String getFilename();

    protected String getCategoryString() {
        return this.messages.getString("category_misc");
    }

    @Override
    public String getId() {
        return "WRONG_WORD_IN_CONTEXT";
    }

    @Override
    public String getDescription() {
        return "Confusion of words";
    }

    public void setMatchLemmmas() {
        this.matchLemmas = true;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (ContextWords contextWords : this.contextWordsSet) {
            String token;
            String lemma;
            int j;
            int i;
            boolean[] matchedWord = new boolean[]{false, false};
            Matcher[] matchers = new Matcher[]{null, null};
            matchers[0] = contextWords.words[0].matcher("");
            matchers[1] = contextWords.words[1].matcher("");
            String token1 = "";
            for (i = 1; i < tokens.length && !matchedWord[0]; ++i) {
                if (tokens[i].hasPartialPosTag("IS_URL")) continue;
                token1 = tokens[i].getToken();
                matchedWord[0] = matchers[0].reset(token1).find();
            }
            String token2 = "";
            for (j = 1; j < tokens.length && !matchedWord[1]; ++j) {
                if (tokens[j].hasPartialPosTag("IS_URL")) continue;
                token2 = tokens[j].getToken();
                matchedWord[1] = matchers[1].reset(token2).find();
            }
            int foundWord = -1;
            int notFoundWord = -1;
            int startPos = 0;
            int endPos = 0;
            String matchedToken = "";
            if (matchedWord[0] && !matchedWord[1]) {
                foundWord = 0;
                notFoundWord = 1;
                matchers[1] = contextWords.contexts[1].matcher("");
                startPos = tokens[i - 1].getStartPos();
                endPos = tokens[i - 1].getStartPos() + token1.length();
                matchedToken = token1;
            } else if (matchedWord[1] && !matchedWord[0]) {
                foundWord = 1;
                notFoundWord = 0;
                matchers[0] = contextWords.contexts[0].matcher("");
                startPos = tokens[j - 1].getStartPos();
                endPos = tokens[j - 1].getStartPos() + token2.length();
                matchedToken = token2;
            }
            if (foundWord == -1) continue;
            boolean[] matchedContext = new boolean[]{false, false};
            matchers[foundWord] = contextWords.contexts[foundWord].matcher("");
            matchers[notFoundWord] = contextWords.contexts[notFoundWord].matcher("");
            for (i = 1; i < tokens.length && !matchedContext[foundWord]; ++i) {
                if (this.matchLemmas) {
                    for (j = 0; j < tokens[i].getReadingsLength() && !matchedContext[foundWord]; ++j) {
                        lemma = tokens[i].getAnalyzedToken(j).getLemma();
                        if (lemma == null || lemma.isEmpty()) continue;
                        matchedContext[foundWord] = matchers[foundWord].reset(lemma).find();
                    }
                    continue;
                }
                token = tokens[i].getToken();
                matchedContext[foundWord] = matchers[foundWord].reset(token).find();
            }
            for (i = 1; i < tokens.length && !matchedContext[notFoundWord]; ++i) {
                if (this.matchLemmas) {
                    for (j = 0; j < tokens[i].getReadingsLength() && !matchedContext[notFoundWord]; ++j) {
                        lemma = tokens[i].getAnalyzedToken(j).getLemma();
                        if (lemma == null || lemma.isEmpty()) continue;
                        matchedContext[notFoundWord] = matchers[notFoundWord].reset(lemma).find();
                    }
                    continue;
                }
                token = tokens[i].getToken();
                matchedContext[notFoundWord] = matchers[notFoundWord].reset(token).find();
            }
            if (!matchedContext[notFoundWord] || matchedContext[foundWord]) continue;
            String repl = matchedToken.replaceFirst(contextWords.matches[foundWord], contextWords.matches[notFoundWord]);
            String msg = this.getMessage(matchedToken, repl, contextWords.explanations[notFoundWord], contextWords.explanations[foundWord]);
            String id = StringTools.toId(this.getId() + "_" + matchedToken + "_" + repl, this.lang);
            String desc = this.getDescription().replace("$match", matchedToken + "/" + repl);
            SpecificIdRule specificIdRule = new SpecificIdRule(id, desc, this.isPremium(), this.getCategory(), this.getLocQualityIssueType(), this.getTags());
            RuleMatch ruleMatch = new RuleMatch(specificIdRule, sentence, startPos, endPos, msg, this.getShortMessageString());
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected abstract String getMessageString();

    protected abstract String getShortMessageString();

    protected abstract String getLongMessageString();

    private String getMessage(String wrongWord, String suggestion, String explanationSuggestion, String explanationWrongWord) {
        String quotedSuggestion = Matcher.quoteReplacement(suggestion);
        String quotedWrongWord = Matcher.quoteReplacement(wrongWord);
        String quotedExplanationSuggestion = Matcher.quoteReplacement(explanationSuggestion);
        String quotedExplanationWrongWord = Matcher.quoteReplacement(explanationWrongWord);
        if (explanationSuggestion.isEmpty() || explanationWrongWord.isEmpty()) {
            return this.getMessageString().replaceFirst("\\$SUGGESTION", quotedSuggestion).replaceFirst("\\$WRONGWORD", quotedWrongWord);
        }
        return this.getLongMessageString().replaceFirst("\\$SUGGESTION", quotedSuggestion).replaceFirst("\\$WRONGWORD", quotedWrongWord).replaceFirst("\\$EXPLANATION_SUGGESTION", quotedExplanationSuggestion).replaceFirst("\\$EXPLANATION_WRONGWORD", quotedExplanationWrongWord);
    }

    private static List<ContextWords> loadContextWords(String path) {
        ArrayList<ContextWords> set = new ArrayList<ContextWords>();
        InputStream stream = JLanguageTool.getDataBroker().getFromRulesDirAsStream(path);
        try (Scanner scanner = new Scanner(stream, "utf-8");){
            while (scanner.hasNextLine()) {
                String[] column;
                String line = scanner.nextLine();
                if (line.trim().isEmpty() || line.charAt(0) == '#' || (column = line.split("\t")).length < 6) continue;
                ContextWords contextWords = new ContextWords();
                contextWords.setWord(0, column[0]);
                contextWords.setWord(1, column[1]);
                contextWords.matches[0] = column[2];
                contextWords.matches[1] = column[3];
                contextWords.setContext(0, column[4]);
                contextWords.setContext(1, column[5]);
                if (column.length > 6) {
                    contextWords.explanations[0] = column[6];
                    if (column.length > 7) {
                        contextWords.explanations[1] = column[7];
                    }
                }
                set.add(contextWords);
            }
        }
        return Collections.unmodifiableList(set);
    }

    static class ContextWords {
        final String[] matches = new String[]{"", ""};
        final String[] explanations = new String[]{"", ""};
        final Pattern[] words = new Pattern[2];
        final Pattern[] contexts = new Pattern[2];

        ContextWords() {
        }

        private String addBoundaries(String str) {
            String ignoreCase = "";
            if (str.startsWith("(?i)")) {
                str = str.substring(4);
                ignoreCase = "(?i)";
            }
            return ignoreCase + "\\b(" + str + ")\\b";
        }

        void setWord(int i, String word) {
            this.words[i] = Pattern.compile(this.addBoundaries(word));
        }

        void setContext(int i, String context) {
            this.contexts[i] = Pattern.compile(this.addBoundaries(context));
        }
    }
}

