/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.PronomsFeblesHelper;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class AdjustVerbSuggestionsFilter
extends RuleFilter {
    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        int posWord;
        JLanguageTool lt = ((PatternRule)match.getRule()).getLanguage().createDefaultJLanguageTool();
        ArrayList<String> replacements = new ArrayList<String>();
        boolean numberFromNextWords = this.getOptional("numberFromNextWords", arguments, "false").equalsIgnoreCase("true");
        String forceNumber = this.getOptional("forceNumber", arguments, "");
        Synthesizer synth = this.getSynthesizerFromRuleMatch(match);
        AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
        for (posWord = 0; posWord < tokens.length && (tokens[posWord].getStartPos() < match.getFromPos() || tokens[posWord].isSentenceStart()); ++posWord) {
        }
        int toLeft = 0;
        boolean done = false;
        String firstVerb = "";
        String firstVerbPersonaNumber = "";
        String firstVerbPersonaNumberImperative = "";
        String replacementVerb = "";
        int firstVerbPos = 0;
        boolean inPronouns = false;
        boolean firstVerbInflected = false;
        String[] twoPronounsAfter = PronomsFeblesHelper.getTwoNextPronouns(tokens, posWord + 1);
        if (Integer.parseInt(twoPronounsAfter[1]) > 0) {
            done = true;
        }
        while (!done && posWord - toLeft > 0) {
            AnalyzedTokenReadings currentTkn = tokens[posWord - toLeft];
            String currentTknStr = currentTkn.getToken();
            boolean isVerb = currentTkn.hasPosTagStartingWith("V");
            boolean isPronoun = currentTkn.matchesPosTagRegex("P0.{6}|PP3CN000|PP3NN000|PP3..A00|PP3CP000|PP3CSD00");
            if (isPronoun) {
                inPronouns = true;
            }
            boolean isInGV = currentTkn.getChunkTags().contains(new ChunkTag("GV"));
            if (isPronoun || isVerb && !inPronouns && !firstVerbInflected && (toLeft == 0 || isInGV) || isInGV && !firstVerbInflected) {
                if (isVerb) {
                    firstVerb = currentTknStr;
                    firstVerbPos = toLeft;
                    firstVerbInflected = currentTkn.matchesPosTagRegex("V.[SI].*");
                    if (firstVerbInflected) {
                        firstVerbPersonaNumber = currentTkn.readingWithTagRegex("V.[SI].*").getPOSTag().substring(4, 6);
                    }
                    if (currentTkn.matchesPosTagRegex("V.M.*")) {
                        firstVerbPersonaNumberImperative = currentTkn.readingWithTagRegex("V.M.*").getPOSTag().substring(4, 6);
                    }
                }
                ++toLeft;
                continue;
            }
            done = true;
            if (toLeft <= 0) continue;
            --toLeft;
        }
        if (posWord - toLeft == 0) {
            --toLeft;
        }
        for (String originalSuggestion : match.getSuggestedReplacements()) {
            AnalyzedToken at;
            String[] synthForms;
            originalSuggestion = originalSuggestion.toLowerCase();
            boolean makeIntrasitive = false;
            if (originalSuggestion.endsWith(" [intr]")) {
                originalSuggestion = originalSuggestion.substring(0, originalSuggestion.length() - 7);
                makeIntrasitive = true;
            }
            int firstSpaceIndex = originalSuggestion.indexOf(" ");
            String newLemma = originalSuggestion;
            String afterLemma = "";
            String desiredNumber = "";
            if (firstSpaceIndex != -1) {
                newLemma = originalSuggestion.substring(0, firstSpaceIndex);
                afterLemma = originalSuggestion.substring(firstSpaceIndex + 1);
                List<AnalyzedSentence> tokensAfterLemma = lt.analyzeText(afterLemma);
                if (numberFromNextWords) {
                    String string = desiredNumber = tokensAfterLemma.get(0).getTokensWithoutWhitespace()[1].hasPartialPosTag("S") ? "S" : "P";
                }
            }
            if (newLemma.equals("haver")) {
                desiredNumber = "S";
            }
            if (!forceNumber.isEmpty()) {
                desiredNumber = forceNumber;
            }
            String action = "removePronounReflexive";
            if (newLemma.endsWith("-se'n")) {
                newLemma = newLemma.substring(0, newLemma.length() - 5);
                action = "addPronounReflexiveEn";
            } else if (newLemma.endsWith("-se")) {
                newLemma = newLemma.substring(0, newLemma.length() - 3);
                action = "addPronounReflexive";
            } else if (newLemma.endsWith("-hi")) {
                newLemma = newLemma.substring(0, newLemma.length() - 3);
                action = "addPronounHi";
            } else if (newLemma.endsWith("-s'ho")) {
                newLemma = newLemma.substring(0, newLemma.length() - 5);
                action = "addPronounReflexiveHo";
            } else if (newLemma.endsWith("-s'hi")) {
                newLemma = newLemma.substring(0, newLemma.length() - 5);
                action = "addPronounReflexiveHi";
            }
            ArrayList<String> postags = new ArrayList<String>();
            for (AnalyzedToken reading : tokens[posWord]) {
                if (reading.getPOSTag() == null || !reading.getPOSTag().startsWith("V")) continue;
                Object postag = reading.getPOSTag();
                if (newLemma.equals("haver")) {
                    postag = "VA" + ((String)postag).substring(2);
                }
                if (newLemma.equals("ser")) {
                    postag = "VS" + ((String)postag).substring(2);
                }
                if (!desiredNumber.isEmpty() && !((String)postag).substring(2, 3).equals("P") && (((String)postag).substring(5, 6).equals("S") || ((String)postag).substring(5, 6).equals("P"))) {
                    postag = ((String)postag).substring(0, 5) + desiredNumber + ((String)postag).substring(6);
                }
                postags.add((String)postag);
            }
            String targetPostag = synth.getTargetPosTag(postags, "");
            if (!targetPostag.isEmpty() && (synthForms = synth.synthesize(at = new AnalyzedToken(tokens[posWord].getToken(), targetPostag, newLemma), targetPostag)) != null && synthForms.length > 0) {
                replacementVerb = synthForms[0];
            }
            StringBuilder sb = new StringBuilder();
            for (int i = posWord - toLeft; i < posWord - firstVerbPos; ++i) {
                sb.append(tokens[i].getToken());
                if (!tokens[i + 1].isWhitespaceBefore()) continue;
                sb.append(" ");
            }
            Object pronounsStr = sb.toString().trim();
            sb = new StringBuilder();
            for (int i = posWord - firstVerbPos; i <= posWord; ++i) {
                if (i == posWord && !replacementVerb.isEmpty()) {
                    sb.append(replacementVerb);
                } else {
                    String newFirstVerb = tokens[i].getToken();
                    if (i == posWord - firstVerbPos) {
                        String number = "";
                        AnalyzedToken atr = tokens[i].readingWithTagRegex("V.[SI].*");
                        if (atr != null) {
                            String[] synthForms2;
                            number = atr.getPOSTag().substring(5, 6);
                            Object postag = atr.getPOSTag();
                            if ((number.equals("S") || number.equals("P") && !number.equals(desiredNumber) && !desiredNumber.isEmpty()) && (synthForms2 = synth.synthesize(atr, (String)(postag = ((String)postag).substring(0, 5) + desiredNumber + ((String)postag).substring(6)))) != null && synthForms2.length > 0) {
                                newFirstVerb = synthForms2[0];
                            }
                        }
                    }
                    sb.append(newFirstVerb);
                }
                if (i + 1 >= tokens.length || !tokens[i + 1].isWhitespaceBefore()) continue;
                sb.append(" ");
            }
            String replacement = "";
            String verbStr = sb.toString().trim().toLowerCase();
            if (!firstVerbInflected) {
                pronounsStr = twoPronounsAfter[0];
            }
            pronounsStr = ((String)pronounsStr).toLowerCase();
            switch (action) {
                case "addPronounEn": {
                    replacement = PronomsFeblesHelper.doAddPronounEn(firstVerb, (String)pronounsStr, verbStr, !firstVerbInflected);
                    break;
                }
                case "removePronounReflexive": {
                    replacement = PronomsFeblesHelper.doRemovePronounReflexive(firstVerb, (String)pronounsStr, verbStr, !firstVerbInflected);
                    break;
                }
                case "addPronounReflexiveEn": {
                    replacement = PronomsFeblesHelper.doAddPronounReflexiveEn(firstVerb, (String)pronounsStr, verbStr, firstVerbPersonaNumber, !firstVerbInflected);
                    break;
                }
                case "replaceEmEn": {
                    replacement = PronomsFeblesHelper.doReplaceEmEn(firstVerb, (String)pronounsStr, verbStr, !firstVerbInflected);
                    break;
                }
                case "addPronounReflexive": {
                    replacement = PronomsFeblesHelper.doAddPronounReflexive(firstVerb, (String)pronounsStr, verbStr, firstVerbPersonaNumber, !firstVerbInflected);
                    break;
                }
                case "addPronounReflexiveHi": {
                    replacement = PronomsFeblesHelper.doAddPronounReflexive(firstVerb, "", "hi " + verbStr, firstVerbPersonaNumber, !firstVerbInflected);
                    break;
                }
                case "addPronounReflexiveHo": {
                    Object newVerbStr = verbStr;
                    if (firstVerbInflected) {
                        newVerbStr = "ho " + verbStr;
                    } else if (!((String)pronounsStr).isEmpty()) {
                        pronounsStr = (String)pronounsStr + "-ho";
                    }
                    replacement = PronomsFeblesHelper.doAddPronounReflexive(firstVerb, (String)pronounsStr, (String)newVerbStr, firstVerbPersonaNumber, !firstVerbInflected);
                    break;
                }
                case "addPronounHi": {
                    replacement = PronomsFeblesHelper.doAddPronounHi(firstVerb, "", verbStr, !firstVerbInflected);
                    break;
                }
                case "addPronounReflexiveImperative": {
                    replacement = PronomsFeblesHelper.doAddPronounReflexiveImperative(firstVerb, (String)pronounsStr, verbStr, firstVerbPersonaNumberImperative);
                }
            }
            if (replacement.isEmpty()) continue;
            if (makeIntrasitive) {
                replacement = PronomsFeblesHelper.convertPronounsForIntransitiveVerb(replacement);
            }
            replacement = PronomsFeblesHelper.fixApostrophes(replacement);
            replacements.add(StringTools.preserveCase(replacement + " " + afterLemma, tokens[posWord - toLeft].getToken()).trim());
        }
        if (replacements.isEmpty()) {
            return null;
        }
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), tokens[posWord - toLeft].getStartPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
        ruleMatch.setType(match.getType());
        ruleMatch.setSuggestedReplacements(replacements);
        return ruleMatch;
    }
}

