/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ApostophationHelper {
    private static Map<String, String> prepDet = new HashMap<String, String>();
    private static final Pattern pMascYes;
    private static final Pattern pMascNo;
    private static final Pattern pFemYes;
    private static final Pattern pFemNo;

    public static String getPrepositionAndDeterminer(String newForm, String genderNumber, String preposition) {
        String apos = "";
        if (!preposition.isEmpty()) {
            preposition = preposition.substring(0, 1).toLowerCase();
        }
        if (genderNumber.equals("MS")) {
            if (pMascYes.matcher(newForm).matches() && !pMascNo.matcher(newForm).matches()) {
                apos = "apos";
            }
        } else if (genderNumber.equals("FS") && pFemYes.matcher(newForm).matches() && !pFemNo.matcher(newForm).matches()) {
            apos = "apos";
        }
        String suggestion = prepDet.get(preposition + genderNumber + apos);
        return suggestion;
    }

    static {
        prepDet.put("MS", "el ");
        prepDet.put("FS", "la ");
        prepDet.put("MP", "els ");
        prepDet.put("FP", "les ");
        prepDet.put("MSapos", "l'");
        prepDet.put("FSapos", "l'");
        prepDet.put("aMS", "al ");
        prepDet.put("aFS", "a la ");
        prepDet.put("aMP", "als ");
        prepDet.put("aFP", "a les ");
        prepDet.put("aMSapos", "a l'");
        prepDet.put("aFSapos", "a l'");
        prepDet.put("dMS", "del ");
        prepDet.put("dFS", "de la ");
        prepDet.put("dMP", "dels ");
        prepDet.put("dFP", "de les ");
        prepDet.put("dMSapos", "de l'");
        prepDet.put("dFSapos", "de l'");
        prepDet.put("pMS", "pel ");
        prepDet.put("pFS", "per la ");
        prepDet.put("pMP", "pels ");
        prepDet.put("pFP", "per les ");
        prepDet.put("pMSapos", "per l'");
        prepDet.put("pFSapos", "per l'");
        pMascYes = Pattern.compile("h?[aeiou\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa].*", 66);
        pMascNo = Pattern.compile("h?[ui][aeio\u00e0\u00e8\u00e9\u00f3\u00f2].+", 66);
        pFemYes = Pattern.compile("h?[aeo\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa].*|h?[ui][^aeiou\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa\u00fc\u00ef]+[aeiou][ns]?|urbs", 66);
        pFemNo = Pattern.compile("host|ira|inxa", 66);
    }
}

