/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.rules.AbstractRepeatedWordsRule;
import org.languagetool.rules.SynonymsData;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class CatalanRepeatedWordsRule
extends AbstractRepeatedWordsRule {
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.csRegex("[Tt]ema|TEMA"), PatternRuleBuilderHelper.csRegex("\\d+|[IXVC]+")));
    private static final Map<String, SynonymsData> wordsToCheck = CatalanRepeatedWordsRule.loadWords("/ca/synonyms.txt");

    @Override
    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    public CatalanRepeatedWordsRule(ResourceBundle messages, Language lang) {
        super(messages, lang);
        this.antiPatterns = CatalanRepeatedWordsRule.cacheAntiPatterns(lang, ANTI_PATTERNS);
        super.setTags(Arrays.asList(Tag.picky));
    }

    @Override
    protected String getMessage() {
        return "Aquesta paraula apareix en una de les frases anteriors. Podeu substituir-la per un sin\u00f2nim per a fer m\u00e9s variat el text, llevat que la repetici\u00f3 sigui intencionada.";
    }

    @Override
    public String getDescription() {
        return "Sin\u00f2nims per a paraules repetides.";
    }

    @Override
    protected Map<String, SynonymsData> getWordsToCheck() {
        return wordsToCheck;
    }

    @Override
    protected String getShortMessage() {
        return "Estil: paraula repetida";
    }

    @Override
    protected Synthesizer getSynthesizer() {
        return this.language.getSynthesizer();
    }

    @Override
    protected String adjustPostag(String postag) {
        if (postag.contains("CN")) {
            return StringUtils.replaceOnce(postag, "CN", "..");
        }
        if (postag.contains("MS")) {
            return StringUtils.replaceOnce(postag, "MS", "[MC][SN]");
        }
        if (postag.contains("FS")) {
            return StringUtils.replaceOnce(postag, "FS", "[FC][SN]");
        }
        if (postag.contains("MP")) {
            return StringUtils.replaceOnce(postag, "MP", "[MC][PN]");
        }
        if (postag.contains("FP")) {
            return StringUtils.replaceOnce(postag, "FP", "[FC][PN]");
        }
        if (postag.contains("CS")) {
            return StringUtils.replaceOnce(postag, "CS", "[MFC][SN]");
        }
        if (postag.contains("CP")) {
            return StringUtils.replaceOnce(postag, "CP", "[MFC][PN]");
        }
        if (postag.contains("MN")) {
            return StringUtils.replaceOnce(postag, "MN", "[MC][SPN]");
        }
        if (postag.contains("FN")) {
            return StringUtils.replaceOnce(postag, "FN", "[FC][SPN]");
        }
        return postag;
    }

    @Override
    protected boolean isException(AnalyzedTokenReadings[] tokens, int i, boolean sentStart, boolean isCapitalized, boolean isAllUppercase) {
        if (isAllUppercase || isCapitalized && !sentStart) {
            return true;
        }
        return tokens[i].hasPosTagStartingWith("NP") || tokens[i].hasPosTag("_english_ignore_");
    }
}

