/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.ca.PronomsFeblesHelper;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.tagging.ca.CatalanTagger;
import org.languagetool.tools.StringTools;

public final class MorfologikCatalanSpellerRule
extends MorfologikSpellerRule {
    private final String dictFilename;
    private static final String SPELLING_FILE = "/ca/spelling.txt";
    private static final Pattern QUOTE_OR_HYPHEN = Pattern.compile("['-]");
    private static final List<String> PARTICULA_INICIAL = Arrays.asList("amb", "sota", "no", "en", "a", "el", "els", "al", "als", "pel", "pels", "del", "dels", "del", "de", "per", "un", "uns", "una", "unes", "la", "les", "teu", "meu", "seu", "teus", "meus", "seus");
    private static final List<String> PREFIX_AMB_ESPAI = Arrays.asList("pod", "ultra", "eco", "tele", "anti", "re", "des", "sen", "sem", "s", "avant", "auto", "ex", "extra", "macro", "mega", "meta", "micro", "multi", "mono", "mini", "post", "retro", "semi", "super", "trans", "pro", "g", "l", "m", "e");
    private static final List<String> ESPAI_AMB_SUFIX = Arrays.asList("a", "o", "i");
    private static final List<String> PRONOM_INICIAL = Arrays.asList("em", "et", "es", "se", "ens", "us", "vos", "li", "hi", "ho", "el", "la", "els", "les");
    private static final Pattern APOSTROF_INICI_VERBS = Pattern.compile("^([lnts])[90]?(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].*)$", 66);
    private static final Pattern APOSTROF_INICI_VERBS_M = Pattern.compile("^(m)[90]?(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].*)$", 66);
    private static final Pattern APOSTROF_INICI_NOM_SING = Pattern.compile("^([ld])[90]?(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa]...+)$", 66);
    private static final Pattern APOSTROF_INICI_NOM_PLURAL = Pattern.compile("^(d)[90]?(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].+)$", 66);
    private static final Pattern APOSTROF_FINAL = Pattern.compile("^(...+[aei])[90]?(l|ls|m|ns|n|t)$", 66);
    private static final Pattern APOSTROF_FINAL_S = Pattern.compile("^(.+e)[90]?(s)$", 66);
    private static final Pattern GUIONET_FINAL = Pattern.compile("^([\\p{L}\u00b7]+)[\u2019']?(hi|ho|la|les|li|lo|los|me|ne|nos|se|te|vos)$", 66);
    private static final Pattern GUIONET_FINAL_GERUNDI = Pattern.compile("^([\\p{L}\u00b7]+n)(hi|ho|la|les|li|lo|los|me|ne|nos|se|te|vos)$", 66);
    private static final List<String> SPLIT_DIGITS_AT_END = Arrays.asList("en", "de", "del", "al", "dels", "als", "a", "i", "o", "amb");
    private static final Pattern VERB_INDSUBJ = Pattern.compile("V.[SI].*");
    private static final Pattern VERB_INDSUBJ_M = Pattern.compile("V.[SI].[123]S.*|V.[SI].[23]P.*");
    private static final Pattern NOM_SING = Pattern.compile("V.[NG].*|V.P..S..|N..[SN].*|A...[SN].|PX..S...|DD..S.");
    private static final Pattern NOM_PLURAL = Pattern.compile("V.P..P..|N..[PN].*|A...[PN].|PX..P...|DD..P.");
    private static final Pattern VERB_INFGERIMP = Pattern.compile("V.[NGM].*");
    private static final Pattern VERB_INF = Pattern.compile("V.N.*");
    private static final Pattern VERB_GER = Pattern.compile("V.G.*");
    public static final String[] LemmasToIgnore = new String[]{"enterar", "sentar", "conseguir", "alcan\u00e7ar", "entimar"};
    public static final String[] LemmasToAllow = new String[]{"enter", "sentir"};
    private static final List<String> inalambric = Arrays.asList("inal\u00e0mbric", "inal\u00e0mbrica", "inal\u00e0mbrics", "inal\u00e0mbriques", "inal\u00e0mbricament", "inal\u00e0mbricamente");
    private static final List<String> PronomsDarrere = Arrays.asList("losels", "losles", "nosels", "nosles", "vosels", "vosens", "vosles", "lesen", "leshi", "liles", "losel", "losen", "loshi", "losho", "losla", "lsels", "lsles", "meles", "nosel", "nosen", "noshi", "nosho", "nosla", "nosli", "nsels", "nsles", "seles", "sevos", "teles", "usels", "usens", "usles", "vosel", "vosem", "vosen", "voshi", "vosho", "vosla", "vosli", "lahi", "lihi", "liho", "lila", "lils", "lsel", "lsen", "lshi", "lsho", "lsla", "mela", "meli", "mels", "nsel", "nsen", "nshi", "nsho", "nsla", "nsli", "sela", "seli", "sels", "sens", "seus", "tela", "teli", "tels", "tens", "usel", "usem", "usen", "ushi", "usho", "usla", "usli", "lan", "len", "les", "lhi", "lil", "lin", "los", "mel", "men", "mhi", "mho", "nhi", "nos", "sel", "sem", "sen", "set", "shi", "sho", "tel", "tem", "ten", "thi", "tho", "vos", "hi", "ho", "la", "li", "lo", "ls", "me", "ne", "ns", "se", "te", "us");
    private CatalanTagger tagger;

    @Override
    public List<String> getAdditionalSpellingFileNames() {
        return Arrays.asList("/ca//hunspell/spelling_custom.txt", "spelling_global.txt", "/ca/multiwords.txt", "/ca/spelling-special.txt");
    }

    public MorfologikCatalanSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        this.setIgnoreTaggedWords();
        String spellingFilename = "ca-ES";
        if (language.getVariant() == "valencia") {
            this.tagger = CatalanTagger.INSTANCE_VAL;
            spellingFilename = "ca-ES-valencia";
        } else {
            this.tagger = CatalanTagger.INSTANCE_CAT;
        }
        this.dictFilename = "/ca/" + spellingFilename + "_spelling.dict";
    }

    @Override
    public String getFileName() {
        return this.dictFilename;
    }

    @Override
    public String getSpellingFileName() {
        return SPELLING_FILE;
    }

    @Override
    public String getId() {
        return "MORFOLOGIK_RULE_CA_ES";
    }

    @Override
    public boolean useInOffice() {
        return true;
    }

    @Override
    protected List<SuggestedReplacement> orderSuggestions(List<SuggestedReplacement> suggestions, String word) {
        ArrayList<SuggestedReplacement> newSuggestions = new ArrayList<SuggestedReplacement>();
        String wordWithouDiacriticsString = StringTools.removeDiacritics(word);
        for (int i = 0; i < suggestions.size(); ++i) {
            int posNewSugg;
            String[] parts;
            String replacement = suggestions.get(i).getReplacement();
            if (inalambric.contains(replacement.toLowerCase())) {
                newSuggestions = new ArrayList();
                newSuggestions.add(new SuggestedReplacement("sense fils"));
                newSuggestions.add(new SuggestedReplacement("sense fil"));
                newSuggestions.add(new SuggestedReplacement("sense cables"));
                newSuggestions.add(new SuggestedReplacement("aut\u00f2nom"));
                return newSuggestions;
            }
            if (replacement.equalsIgnoreCase("como")) continue;
            boolean ignoreSuggestion = false;
            String[] wordsToAnalyze = replacement.split("[ '-]");
            List<AnalyzedTokenReadings> newatrs = this.tagger.tag(Arrays.asList(wordsToAnalyze));
            for (AnalyzedTokenReadings newatr : newatrs) {
                if (!newatr.hasAnyLemma(LemmasToIgnore) || newatr.hasAnyLemma(LemmasToAllow)) continue;
                ignoreSuggestion = true;
                break;
            }
            if (ignoreSuggestion) continue;
            if (replacement.contains("' ")) {
                suggestions.get(i).setReplacement(replacement.replace("' ", "'"));
            }
            if ((parts = replacement.split(" ")).length == 2 && (parts[1].toLowerCase().equals("s") || PREFIX_AMB_ESPAI.contains(parts[0].toLowerCase()) || parts[1].length() == 1 && !ESPAI_AMB_SUFIX.contains(parts[1].toLowerCase()))) continue;
            for (posNewSugg = 0; newSuggestions.size() > posNewSugg && StringTools.removeDiacritics(((SuggestedReplacement)newSuggestions.get(posNewSugg)).getReplacement()).equalsIgnoreCase(wordWithouDiacriticsString); ++posNewSugg) {
            }
            if (parts.length == 2) {
                List<AnalyzedTokenReadings> atkn;
                String newSuggestion;
                if (parts[1].length() > 1 && PARTICULA_INICIAL.contains(parts[0].toLowerCase())) {
                    boolean isBalear;
                    newSuggestion = parts[1];
                    atkn = this.tagger.tag(Arrays.asList(newSuggestion));
                    boolean bl = isBalear = atkn.get(0).hasPosTag("VMIP1S0B") && !atkn.get(0).hasPosTagStartingWith("N");
                    if (!isBalear) {
                        newSuggestions.add(posNewSugg, suggestions.get(i));
                        continue;
                    }
                }
                if (parts[1].length() > 1 && PRONOM_INICIAL.contains(parts[0].toLowerCase()) && (atkn = this.tagger.tag(Arrays.asList(newSuggestion = parts[1]))).get(0).matchesPosTagRegex(VERB_INDSUBJ)) {
                    newSuggestions.add(posNewSugg, suggestions.get(i));
                    continue;
                }
            }
            String suggWithoutDiacritics = StringTools.removeDiacritics(replacement);
            if (StringTools.removeDiacritics(word).equalsIgnoreCase(suggWithoutDiacritics)) {
                newSuggestions.add(posNewSugg, suggestions.get(i));
                continue;
            }
            String cleanSuggestion = QUOTE_OR_HYPHEN.matcher(replacement).replaceAll("");
            if (i > 1 && suggestions.size() > 2 && cleanSuggestion.equalsIgnoreCase(word)) {
                if (posNewSugg == 0) {
                    posNewSugg = 1;
                }
                newSuggestions.add(posNewSugg, suggestions.get(i));
                continue;
            }
            if (i == 1 && !suggestions.get(0).getReplacement().contains("-") && (suggestions.get(0).getReplacement().endsWith("'n") || suggestions.get(0).getReplacement().endsWith("'t"))) {
                newSuggestions.add(0, suggestions.get(i));
                continue;
            }
            newSuggestions.add(suggestions.get(i));
        }
        return newSuggestions;
    }

    @Override
    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        List<String> suggestionsList = suggestions.stream().map(SuggestedReplacement::getReplacement).collect(Collectors.toList());
        return SuggestedReplacement.convert(this.getAdditionalTopSuggestionsString(suggestionsList, word));
    }

    private List<String> getAdditionalTopSuggestionsString(List<String> suggestions, String word) throws IOException {
        CharSequence[] parts = StringTools.splitCamelCase(word);
        if (parts.length > 1 && parts[0].length() > 1) {
            boolean isNotMisspelled = true;
            for (String string : parts) {
                isNotMisspelled &= !this.speller1.isMisspelled(string);
            }
            if (isNotMisspelled) {
                return Collections.singletonList(String.join((CharSequence)" ", parts));
            }
        }
        if ((parts = StringTools.splitDigitsAtEnd(word)).length > 1 && this.tagger.tag(Arrays.asList(parts[0])).get(0).isTagged() && (((String)parts[0]).length() > 2 || SPLIT_DIGITS_AT_END.contains(((String)parts[0]).toLowerCase()))) {
            return Collections.singletonList(String.join((CharSequence)" ", parts));
        }
        String suggestion = "";
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_INICI_VERBS, VERB_INDSUBJ, 2, "'", "");
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_INICI_VERBS_M, VERB_INDSUBJ_M, 2, "'", "");
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_INICI_NOM_SING, NOM_SING, 2, "'", "");
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_INICI_NOM_PLURAL, NOM_PLURAL, 2, "'", "");
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_FINAL, VERB_INFGERIMP, 1, "'", "");
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_FINAL_S, VERB_INF, 1, "'", "");
        suggestion = this.findSuggestion(suggestion, word, GUIONET_FINAL_GERUNDI, VERB_GER, 1, "-", "t");
        suggestion = this.findSuggestion(suggestion, word, GUIONET_FINAL, VERB_INFGERIMP, 1, "-", "");
        if (!(suggestion = this.findSuggestionMultiplePronouns(suggestion, word)).isEmpty()) {
            return Collections.singletonList(suggestion);
        }
        return Collections.emptyList();
    }

    private String findSuggestion(String suggestion, String word, Pattern wordPattern, Pattern postagPattern, int suggestionPosition, String separator, String addStr) throws IOException {
        String newSuggestion;
        AnalyzedTokenReadings newatr;
        if (!suggestion.isEmpty()) {
            return suggestion;
        }
        Matcher matcher = wordPattern.matcher(word);
        if (matcher.matches() && (!(newatr = this.tagger.tag(Arrays.asList(newSuggestion = matcher.group(suggestionPosition) + addStr)).get(0)).hasPosTag("VMIP1S0B") || newSuggestion.equalsIgnoreCase("fer") || newSuggestion.equalsIgnoreCase("ajust") || newSuggestion.equalsIgnoreCase("gran")) && this.matchPostagRegexp(newatr, postagPattern)) {
            return matcher.group(1) + addStr + separator + matcher.group(2);
        }
        return "";
    }

    private String findSuggestionMultiplePronouns(String suggestion, String word) {
        if (!suggestion.isEmpty()) {
            return suggestion;
        }
        String lcword = word.toLowerCase();
        String pronouns = this.endsWithPronoun(lcword);
        String verb = lcword.substring(0, word.length() - pronouns.length());
        AnalyzedTokenReadings newatr = this.tagger.tag(Arrays.asList(verb)).get(0);
        if (this.matchPostagRegexp(newatr, VERB_INFGERIMP)) {
            return verb + PronomsFeblesHelper.transformDarrere(pronouns, verb);
        }
        if (verb.length() < 5) {
            return "";
        }
        if ((lcword.startsWith("d") || lcword.startsWith("l")) && this.matchPostagRegexp(newatr = this.tagger.tag(Arrays.asList(verb = verb.substring(1, verb.length()))).get(0), VERB_INF)) {
            return lcword.substring(0, 1) + "'" + verb + PronomsFeblesHelper.transformDarrere(pronouns, verb);
        }
        return "";
    }

    private String endsWithPronoun(String s2) {
        for (String pronoun : PronomsDarrere) {
            if (!s2.endsWith(pronoun)) continue;
            return pronoun;
        }
        return "";
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m4;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m4 = pattern.matcher(posTag)).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean tokenizeNewWords() {
        return false;
    }
}

