/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.Tag;
import org.languagetool.language.Catalan;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceAdverbsMent
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceAdverbsMent.loadFromPath("/ca/replace_adverbs_ment.txt");
    private static final Locale CA_LOCALE = new Locale("CA");

    @Override
    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceAdverbsMent(ResourceBundle messages) throws IOException {
        super(messages, Catalan.getInstance());
        super.setCategory(new Category(new CategoryId("PICKY_STYLE"), "regles d'estil, mode perfeccionaista"));
        super.setLocQualityIssueType(ITSIssueType.Style);
        super.setDefaultOff();
        this.setCheckLemmas(false);
        this.setTags(Arrays.asList(Tag.picky));
        super.setUrl(new URL("https://esadir.cat/gramatica/sintaxi/advermanera"));
    }

    @Override
    public final String getId() {
        return "ADVERBIS_MENT";
    }

    @Override
    public String getDescription() {
        return "Alternatives a adverbis acabats en -ment: $match";
    }

    @Override
    public String getShort() {
        return "Alternatives a adverbis acabats en -ment";
    }

    @Override
    public String getMessage(String tokenStr, List<String> replacements) {
        return "A vegades s'abusa dels adverbis acabats en -ment en detriment de formes m\u00e9s \u00e0gils.";
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public Locale getLocale() {
        return CA_LOCALE;
    }
}

