/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.Catalan;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;

public class SimpleReplaceAnglicism
extends AbstractSimpleReplaceRule2 {
    private static final String FILE_NAME = "/ca/replace_anglicism.txt";
    private static final Locale CA_LOCALE = new Locale("ca");

    public SimpleReplaceAnglicism(ResourceBundle messages) throws IOException {
        super(messages, Catalan.getInstance());
        this.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.useSubRuleSpecificIds();
    }

    @Override
    public final String getId() {
        return "CA_SIMPLE_REPLACE_ANGLICISM";
    }

    @Override
    public String getDescription() {
        return "Anglicismes innecessaris: $match";
    }

    @Override
    public String getShort() {
        return "Anglicisme innecessari";
    }

    @Override
    public Locale getLocale() {
        return CA_LOCALE;
    }

    @Override
    public List<String> getFileNames() {
        return Arrays.asList(FILE_NAME);
    }

    @Override
    public String getMessage() {
        return "Anglicisme innecessari. Considereu fer servir una altra paraula.";
    }

    @Override
    protected boolean isRuleMatchException(RuleMatch ruleMatch) {
        int endIndex;
        int startIndex;
        AnalyzedTokenReadings[] tokens = ruleMatch.getSentence().getTokensWithoutWhitespace();
        for (startIndex = 0; startIndex < tokens.length && tokens[startIndex].getStartPos() < ruleMatch.getFromPos(); ++startIndex) {
        }
        for (endIndex = startIndex; endIndex < tokens.length && tokens[endIndex].getEndPos() < ruleMatch.getToPos(); ++endIndex) {
        }
        if (startIndex > 1 && tokens[startIndex].hasPosTag("_english_ignore_") && tokens[startIndex - 1].hasPosTag("_english_ignore_")) {
            return true;
        }
        return endIndex + 1 < tokens.length && tokens[endIndex].hasPosTag("_english_ignore_") && tokens[endIndex + 1].hasPosTag("_english_ignore_");
    }

    @Override
    protected boolean isTokenException(AnalyzedTokenReadings atr) {
        return atr.hasPosTagStartingWith("NP") && atr.getToken().length() > 1 || atr.isImmunized() || atr.isIgnoredBySpeller();
    }
}

