/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceBalearicRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceBalearicRule.loadFromPath("/ca/replace_balearic.txt");
    private static final Locale CA_LOCALE = new Locale("CA");

    @Override
    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceBalearicRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Grammar);
        this.setCheckLemmas(false);
        super.useSubRuleSpecificIds();
    }

    @Override
    public final String getId() {
        return "CA_SIMPLE_REPLACE_BALEARIC";
    }

    @Override
    public String getDescription() {
        return "Suggeriments per a formes balears: $match";
    }

    @Override
    public String getShort() {
        return "Possible error ortogr\u00e0fic.";
    }

    @Override
    public String getMessage(String tokenStr, List<String> replacements) {
        return "Possible error ortogr\u00e0fic (forma verbal v\u00e0lida en la varietat balear).";
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public Locale getLocale() {
        return CA_LOCALE;
    }

    @Override
    protected boolean isTokenException(AnalyzedTokenReadings atr) {
        return atr.hasPosTagStartingWith("NP") || atr.isImmunized() || atr.isIgnoredBySpeller() || atr.hasPosTag("_english_ignore_");
    }
}

