/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.ca.AbstractSimpleReplaceLemmasRule;

public class SimpleReplaceDNVRule
extends AbstractSimpleReplaceLemmasRule {
    private static final LoadingCache<String, Map<String, List<String>>> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build(new CacheLoader<String, Map<String, List<String>>>(){

        @Override
        public Map<String, List<String>> load(@NotNull String path) {
            return SimpleReplaceDNVRule.loadFromPath(path);
        }
    });

    public SimpleReplaceDNVRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(Categories.REGIONALISMS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Style);
        super.useSubRuleSpecificIds();
        this.wrongLemmas = cache.getUnchecked("/ca/replace_dnv.txt");
    }

    @Override
    public final String getId() {
        return "CA_SIMPLE_REPLACE_DNV";
    }

    @Override
    public String getDescription() {
        return "Detecta paraules admeses nom\u00e9s per l'AVL i proposa suggeriments de canvi";
    }

    @Override
    public String getShort() {
        return "Paraula admesa nom\u00e9s pel DNV (AVL).";
    }

    @Override
    public String getMessage(String tokenStr, List<String> replacements) {
        return "Paraula admesa pel DNV (AVL), per\u00f2 no per altres diccionaris.";
    }
}

