/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceDiacriticsIEC
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceDiacriticsIEC.loadFromPath("/ca/replace_diacritics_iec.txt");
    private static final Locale CA_LOCALE = new Locale("CA");

    @Override
    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceDiacriticsIEC(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(new Category(new CategoryId("DIACRITICS_IEC"), "Z) Accents diacr\u00edtics segons l'IEC"));
        super.setLocQualityIssueType(ITSIssueType.Grammar);
        super.setDefaultOn();
        this.setCheckLemmas(false);
        super.useSubRuleSpecificIds();
    }

    @Override
    public final String getId() {
        return "CA_SIMPLE_REPLACE_DIACRITICS_IEC";
    }

    @Override
    public String getDescription() {
        return "Accents diacr\u00edtics segons les normes noves (2017): $match";
    }

    @Override
    public String getShort() {
        return "Hi sobra l'accent.";
    }

    @Override
    public String getMessage(String tokenStr, List<String> replacements) {
        return "Hi sobra l'accent diacr\u00edtic (segons les normes noves).";
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public Locale getLocale() {
        return CA_LOCALE;
    }

    @Override
    protected boolean isTokenException(AnalyzedTokenReadings atr) {
        return atr.hasPosTagStartingWith("NP");
    }
}

