/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Languages;
import org.languagetool.rules.AbstractWordCoherencyRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordCoherencyDataLoader;
import org.languagetool.synthesis.Synthesizer;

public class WordCoherencyValencianRule
extends AbstractWordCoherencyRule {
    private static final Map<String, Set<String>> wordMap = new WordCoherencyDataLoader().loadWords("/ca/coherency-valencia.txt");
    private final Synthesizer synth = Languages.getLanguageForShortCode("ca").getSynthesizer();
    private final Pattern allowedPostags = Pattern.compile("[VAND].*");

    public WordCoherencyValencianRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setCategory(Categories.STYLE.getCategory(messages));
        this.addExamplePair(Example.wrong("<marker>Este</marker> home d'ac\u00ed parla amb <marker>aquest</marker> altre ac\u00ed."), Example.fixed("<marker>Este</marker> home d'ac\u00ed parla amb <marker>este</marker> altre ac\u00ed."));
    }

    @Override
    protected Map<String, Set<String>> getWordMap() {
        return wordMap;
    }

    @Override
    protected String getMessage(String word1, String word2) {
        return "No \u00e9s coherent usar '" + word1 + "' i '" + word2 + "' dins d'un mateix text.";
    }

    @Override
    public String getId() {
        return "CA_WORD_COHERENCY_VALENCIA";
    }

    @Override
    public String getShortMessage() {
        return "Coher\u00e8ncia";
    }

    @Override
    public String getDescription() {
        return "Detecta l'\u00fas incoherent de diferents formes dins d'un text.";
    }

    @Override
    protected String createReplacement(String marked, String token, String otherSpelling, AnalyzedTokenReadings atrs) {
        AnalyzedToken atr = atrs.readingWithTagRegex(this.allowedPostags);
        if (atr != null) {
            String[] synthesizedForms;
            try {
                synthesizedForms = this.synth.synthesize(new AnalyzedToken("", "", otherSpelling), atr.getPOSTag());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (synthesizedForms != null && synthesizedForms.length > 0) {
                return synthesizedForms[0];
            }
        }
        return super.createReplacement(marked, token, otherSpelling, atrs);
    }
}

