/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.Locale;
import org.languagetool.Language;
import org.languagetool.rules.patterns.Match;
import org.languagetool.tools.StringTools;

public final class CaseConversionHelper {
    private CaseConversionHelper() {
    }

    public static String convertCase(Match.CaseConversion conversion, String s2, String sample, Language lang) {
        if (StringTools.isEmpty(s2)) {
            return s2;
        }
        Object token = s2;
        switch (conversion) {
            case NONE: {
                break;
            }
            case PRESERVE: {
                if (!StringTools.startsWithUppercase(sample)) break;
                if (StringTools.isAllUppercase(sample)) {
                    token = ((String)token).toUpperCase(Locale.ENGLISH);
                    break;
                }
                token = StringTools.uppercaseFirstChar((String)token, lang);
                break;
            }
            case STARTLOWER: {
                token = ((String)token).substring(0, 1).toLowerCase() + ((String)token).substring(1);
                break;
            }
            case STARTUPPER: {
                token = StringTools.uppercaseFirstChar((String)token, lang);
                break;
            }
            case ALLUPPER: {
                token = ((String)token).toUpperCase(Locale.ENGLISH);
                break;
            }
            case FIRSTUPPER: {
                token = ((String)token).toLowerCase();
                token = StringTools.uppercaseFirstChar((String)token, lang);
                break;
            }
            case ALLLOWER: {
                token = ((String)token).toLowerCase();
                break;
            }
            case NOTASHKEEL: {
                token = StringTools.removeTashkeel((String)token);
                break;
            }
        }
        return token;
    }
}

