/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SameRuleGroupFilter;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleTransformer;

public class RepeatedPatternRuleTransformer
implements PatternRuleTransformer {
    protected int defaultMaxDistanceTokens = 60;
    protected final Language transformerLanguage;

    public RepeatedPatternRuleTransformer(Language lang) {
        this.transformerLanguage = lang;
    }

    @Override
    public PatternRuleTransformer.TransformedRules apply(List<AbstractPatternRule> patternRules) {
        ArrayList<AbstractPatternRule> remaining = new ArrayList<AbstractPatternRule>();
        HashMap<String, List> toTransform = new HashMap<String, List>();
        for (AbstractPatternRule abstractPatternRule : patternRules) {
            if (abstractPatternRule.getMinPrevMatches() > 0) {
                toTransform.compute(abstractPatternRule.getId(), (id, rules) -> {
                    if (rules == null) {
                        return new ArrayList<AbstractPatternRule>(Collections.singletonList(abstractPatternRule));
                    }
                    rules.add(abstractPatternRule);
                    return rules;
                });
                continue;
            }
            remaining.add(abstractPatternRule);
        }
        List<Rule> transformed = toTransform.values().stream().map(group -> new RepeatedPatternRule((List<AbstractPatternRule>)group, this.transformerLanguage)).collect(Collectors.toList());
        return new PatternRuleTransformer.TransformedRules(remaining, transformed);
    }

    public class RepeatedPatternRule
    extends TextLevelRule {
        protected final Language ruleLanguage;
        private final List<AbstractPatternRule> rules;

        RepeatedPatternRule(List<AbstractPatternRule> rules, Language lang) {
            this.rules = Collections.unmodifiableList(rules);
            this.ruleLanguage = lang;
            this.setPremium(rules.stream().anyMatch(r -> r.isPremium()));
        }

        public List<AbstractPatternRule> getWrappedRules() {
            return this.rules;
        }

        @Override
        public String getId() {
            return this.rules.get(0).getId();
        }

        @Override
        public String getDescription() {
            return this.rules.get(0).getDescription();
        }

        @Override
        public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
            ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
            int offsetChars = 0;
            int offsetTokens = 0;
            int prevFromToken = 0;
            int prevMatches = 0;
            ArrayList<Integer> distancesBetweenMatches = new ArrayList<Integer>();
            for (AnalyzedSentence s2 : sentences) {
                List<RuleMatch> sentenceMatches = new ArrayList<RuleMatch>();
                for (AbstractPatternRule rule : this.rules) {
                    RuleMatch[] ruleMatches = rule.match(s2);
                    sentenceMatches.addAll(Arrays.asList(ruleMatches));
                }
                sentenceMatches = new SameRuleGroupFilter().filter(sentenceMatches);
                int sentenceLenghtTokens = s2.getTokensWithoutWhitespace().length;
                for (RuleMatch m4 : sentenceMatches) {
                    int fromToken;
                    for (fromToken = 0; fromToken < sentenceLenghtTokens && s2.getTokensWithoutWhitespace()[fromToken].getStartPos() < m4.getFromPos(); ++fromToken) {
                    }
                    fromToken += offsetTokens;
                    int fromPos = m4.getFromPos() + offsetChars;
                    int toPos = m4.getToPos() + offsetChars;
                    m4.setOffsetPosition(fromPos, toPos);
                    int maxDistanceTokens = m4.getRule().getDistanceTokens();
                    if (maxDistanceTokens < 1) {
                        maxDistanceTokens = RepeatedPatternRuleTransformer.this.defaultMaxDistanceTokens * m4.getRule().getMinPrevMatches();
                    }
                    distancesBetweenMatches.add(fromToken - prevFromToken);
                    if (prevMatches >= m4.getRule().getMinPrevMatches() && this.isDistanceValid(distancesBetweenMatches, maxDistanceTokens, m4.getRule().getMinPrevMatches())) {
                        matches.add(m4);
                    }
                    prevFromToken = fromToken;
                    ++prevMatches;
                }
                offsetChars += s2.getText().length();
                offsetTokens += sentenceLenghtTokens - 1;
            }
            return matches.toArray(RuleMatch.EMPTY_ARRAY);
        }

        @Override
        public int minToCheckParagraph() {
            return 0;
        }

        @Override
        public boolean supportsLanguage(Language language) {
            return language.equalsConsiderVariantsIfSpecified(this.ruleLanguage);
        }

        private boolean isDistanceValid(List<Integer> distancesBetweenMatches, int maxDistanceTokens, int minPrevMatches) {
            int size = distancesBetweenMatches.size();
            int distance = 0;
            for (int i = 0; i < minPrevMatches && i < size; ++i) {
                distance += distancesBetweenMatches.get(size - 1 - i).intValue();
            }
            return distance < maxDistanceTokens;
        }
    }
}

