/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.suggestions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.rules.spelling.suggestions.SuggestionChangesDataset;
import org.languagetool.rules.spelling.suggestions.SuggestionChangesExperiment;
import org.languagetool.rules.spelling.suggestions.SuggestionChangesExperimentRuns;
import org.languagetool.rules.spelling.suggestions.SuggestionChangesTestConfig;

public class SuggestionsChanges {
    private static SuggestionsChanges instance;
    private final SuggestionChangesTestConfig config;
    private final List<SuggestionChangesExperiment> experiments;
    private final ConcurrentMap<SuggestionChangesExperiment, Integer> correctSuggestions = new ConcurrentHashMap<SuggestionChangesExperiment, Integer>();
    private final ConcurrentMap<SuggestionChangesExperiment, Integer> notFoundSuggestions = new ConcurrentHashMap<SuggestionChangesExperiment, Integer>();
    private final ConcurrentMap<SuggestionChangesExperiment, Integer> suggestionPosSum = new ConcurrentHashMap<SuggestionChangesExperiment, Integer>();
    private final ConcurrentMap<SuggestionChangesExperiment, Integer> textSize = new ConcurrentHashMap<SuggestionChangesExperiment, Integer>();
    private final ConcurrentMap<SuggestionChangesExperiment, Long> computationTime = new ConcurrentHashMap<SuggestionChangesExperiment, Long>();
    private final ConcurrentMap<SuggestionChangesExperiment, Integer> numSamples = new ConcurrentHashMap<SuggestionChangesExperiment, Integer>();
    private final ConcurrentMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Integer> datasetCorrectSuggestions = new ConcurrentHashMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Integer>();
    private final ConcurrentMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Integer> datasetNotFoundSuggestions = new ConcurrentHashMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Integer>();
    private final ConcurrentMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Integer> datasetSuggestionPosSum = new ConcurrentHashMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Integer>();
    private final ConcurrentMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Integer> datasetNumSamples = new ConcurrentHashMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Integer>();
    private final ConcurrentMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Integer> datasetTextSize = new ConcurrentHashMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Integer>();
    private final ConcurrentMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Long> datasetComputationTime = new ConcurrentHashMap<Pair<SuggestionChangesExperiment, SuggestionChangesDataset>, Long>();
    private SuggestionChangesExperiment currentExperiment = null;

    private SuggestionsChanges(SuggestionChangesTestConfig config, BufferedWriter reportWriter) {
        this.config = config;
        this.experiments = this.generateExperiments(config.experiments);
        Runtime.getRuntime().addShutdownHook(new Thread(new Report(reportWriter)));
    }

    @Nullable
    public static SuggestionsChanges getInstance() {
        return instance;
    }

    static void init(@NotNull SuggestionChangesTestConfig config, @Nullable BufferedWriter reportWriter) {
        instance = new SuggestionsChanges(config, reportWriter);
    }

    private List<Map<String, Object>> gridsearch(SortedMap<String, List<Object>> grid, List<Map<String, Object>> current) {
        if (grid.isEmpty()) {
            return current;
        }
        String name = grid.lastKey();
        List params = (List)grid.get(name);
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        if (current.isEmpty()) {
            for (Object value : params) {
                result.add(Collections.singletonMap(name, value));
            }
        } else {
            for (Map<String, Object> entry : current) {
                for (Object value : params) {
                    HashMap<String, Object> modified = new HashMap<String, Object>(entry);
                    modified.put(name, value);
                    result.add(modified);
                }
            }
        }
        return this.gridsearch(grid.headMap(name), result);
    }

    private List<SuggestionChangesExperiment> generateExperiments(List<SuggestionChangesExperimentRuns> experimentSpecs) {
        LinkedList<SuggestionChangesExperiment> experiments = new LinkedList<SuggestionChangesExperiment>();
        for (SuggestionChangesExperimentRuns spec : experimentSpecs) {
            if (spec.parameters == null) {
                experiments.add(new SuggestionChangesExperiment(spec.name, Collections.emptyMap()));
                continue;
            }
            TreeMap<String, List<Object>> params = new TreeMap<String, List<Object>>(spec.parameters);
            List<Map<String, Object>> combinations = this.gridsearch(params, Collections.emptyList());
            for (Map<String, Object> settings : combinations) {
                experiments.add(new SuggestionChangesExperiment(spec.name, settings));
            }
        }
        return experiments;
    }

    public SuggestionChangesTestConfig getConfig() {
        return this.config;
    }

    @Nullable
    public SuggestionChangesExperiment getCurrentExperiment() {
        return this.currentExperiment;
    }

    public void setCurrentExperiment(@Nullable SuggestionChangesExperiment experiment) {
        this.currentExperiment = experiment;
    }

    public static boolean isRunningExperiment(String name) {
        if (SuggestionsChanges.getInstance() == null) {
            return false;
        }
        SuggestionChangesExperiment experiment = SuggestionsChanges.getInstance().getCurrentExperiment();
        return experiment != null && experiment.name.equals(name);
    }

    public void trackExperimentResult(Pair<SuggestionChangesExperiment, SuggestionChangesDataset> source, int position, int resultTextSize, long resultComputationTime) {
        this.numSamples.compute(source.getKey(), (ex, value) -> value == null ? 1 : value + 1);
        this.datasetNumSamples.compute(source, (ex, value) -> value == null ? 1 : value + 1);
        this.textSize.compute(source.getKey(), (ex, value) -> value == null ? resultTextSize : value + resultTextSize);
        this.datasetTextSize.compute(source, (ex, value) -> value == null ? resultTextSize : value + resultTextSize);
        this.computationTime.compute(source.getKey(), (ex, value) -> value == null ? resultComputationTime : value + resultComputationTime);
        this.datasetComputationTime.compute(source, (ex, value) -> value == null ? resultComputationTime : value + resultComputationTime);
        if (position == 0) {
            this.correctSuggestions.compute(source.getKey(), (ex, value) -> value == null ? 1 : value + 1);
            this.datasetCorrectSuggestions.compute(source, (ex, value) -> value == null ? 1 : value + 1);
        }
        if (position == -1) {
            this.notFoundSuggestions.compute(source.getKey(), (ex, value) -> value == null ? 1 : value + 1);
            this.datasetNotFoundSuggestions.compute(source, (ex, value) -> value == null ? 1 : value + 1);
        } else {
            this.suggestionPosSum.compute(source.getKey(), (ex, value) -> value == null ? position : value + position);
            this.datasetSuggestionPosSum.compute(source, (ex, value) -> value == null ? position : value + position);
        }
    }

    public List<SuggestionChangesExperiment> getExperiments() {
        return this.experiments;
    }

    private class Report
    implements Runnable {
        private final BufferedWriter reportWriter;

        Report(BufferedWriter reportWriter) {
            this.reportWriter = reportWriter;
        }

        @Override
        public void run() {
            if (this.reportWriter == null) {
                return;
            }
            try {
                StringBuilder report = new StringBuilder();
                report.append("Overall report:\n\n");
                SuggestionChangesExperiment best = null;
                int bestId = -1;
                double bestAccuracy = 0.0;
                int experimentId = 0;
                for (SuggestionChangesExperiment experiment : SuggestionsChanges.this.experiments) {
                    ++experimentId;
                    int correct = SuggestionsChanges.this.correctSuggestions.getOrDefault(experiment, 0);
                    int score = SuggestionsChanges.this.suggestionPosSum.getOrDefault(experiment, 0);
                    int notFound = SuggestionsChanges.this.notFoundSuggestions.getOrDefault(experiment, 0);
                    int total = SuggestionsChanges.this.numSamples.getOrDefault(experiment, 0);
                    double accuracy = (double)correct / (double)total * 100.0;
                    double speed = (double)SuggestionsChanges.this.textSize.getOrDefault(experiment, 0).intValue() / (double)SuggestionsChanges.this.computationTime.getOrDefault(experiment, 0L).longValue() * 1000.0;
                    if (accuracy > bestAccuracy) {
                        best = experiment;
                        bestAccuracy = accuracy;
                        bestId = experimentId;
                    }
                    report.append(String.format("Experiment #%d (%s): %d / %d correct suggestions -> %f%% accuracy; score (less = better): %d; not found: %d; processed %f chars/second.%n", experimentId, experiment, correct, total, accuracy, score, notFound, speed));
                }
                report.append(String.format("%nBest experiment: #%d (%s) @ %f%% accuracy%n", bestId, best, bestAccuracy));
                for (SuggestionChangesDataset dataset : SuggestionsChanges.this.config.datasets) {
                    report.append(String.format("%nReport for dataset: %s%n", dataset.name));
                    best = null;
                    bestAccuracy = 0.0;
                    bestId = -1;
                    experimentId = 0;
                    for (SuggestionChangesExperiment experiment : SuggestionsChanges.this.experiments) {
                        ++experimentId;
                        Pair<SuggestionChangesExperiment, SuggestionChangesDataset> source = Pair.of(experiment, dataset);
                        int correct = SuggestionsChanges.this.datasetCorrectSuggestions.getOrDefault(source, 0);
                        int score = SuggestionsChanges.this.datasetSuggestionPosSum.getOrDefault(source, 0);
                        int notFound = SuggestionsChanges.this.datasetNotFoundSuggestions.getOrDefault(source, 0);
                        int total = SuggestionsChanges.this.datasetNumSamples.getOrDefault(source, 0);
                        double accuracy = (double)correct / (double)total * 100.0;
                        double speed = (double)SuggestionsChanges.this.datasetTextSize.getOrDefault(source, 0).intValue() / (double)SuggestionsChanges.this.datasetComputationTime.getOrDefault(source, 0L).longValue() * 1000.0;
                        if (accuracy > bestAccuracy) {
                            best = experiment;
                            bestAccuracy = accuracy;
                            bestId = experimentId;
                        }
                        report.append(String.format("Experiment #%d (%s): %d / %d correct suggestions-> %f%% accuracy; score (less = better): %d; not found: %d; processed %f chars/second.%n", experimentId, experiment, correct, total, accuracy, score, notFound, speed));
                    }
                    report.append(String.format("%nBest experiment: #%d (%s) @ %f%% accuracy%n", bestId, best, bestAccuracy));
                }
                System.out.println(report);
                this.reportWriter.write(report.toString());
                this.reportWriter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

