/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ner;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.languagetool.tools.CircuitBreakers;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NERService {
    private static final Logger logger = LoggerFactory.getLogger(NERService.class);
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("lt-ner-thread-%d").build());
    private static final int TIMEOUT_MILLIS = 500;
    private static final Duration slowDurationThreshold = Duration.ofMillis(400L);
    private static final int slowRateThreshold = 80;
    private static final int failureRateThreshold = 50;
    private static final Duration waitDurationOpen = Duration.ofSeconds(60L);
    private static final CircuitBreaker circuitBreaker;
    private final String urlStr;

    public NERService(String urlStr) {
        this.urlStr = urlStr;
    }

    public List<Span> runNER(String text) {
        String result;
        String joined = text.replace('\n', ' ');
        try {
            result = circuitBreaker.executeCallable(() -> NERService.postTo(Tools.getUrl(this.urlStr), "input=" + URLEncoder.encode(joined, "utf-8"), new HashMap<String, String>()));
        }
        catch (Exception e) {
            logger.warn("Failed to run NER, will continue with no named entities", e);
            return Collections.emptyList();
        }
        return this.parseBuffer(result);
    }

    private static String postTo(URL url, String encodedPostData, Map<String, String> properties) {
        try {
            Future<String> future = executorService.submit(() -> {
                URLConnection connection = url.openConnection();
                for (Map.Entry entry : properties.entrySet()) {
                    connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
                connection.setDoOutput(true);
                try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);){
                    writer.write(encodedPostData);
                    ((Writer)writer).flush();
                    String string = StringTools.streamToString(connection.getInputStream(), "UTF-8");
                    return string;
                }
            });
            return future.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timeout (500ms) exhausted getting NER results", e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    List<Span> parseBuffer(String buffer) {
        String[] values = buffer.trim().split(" ");
        if (buffer.trim().contains("\n")) {
            logger.warn("Got multiple lines to read from external NER, this should not happen: '" + buffer.trim() + "'");
        }
        ArrayList<Span> res = new ArrayList<Span>();
        for (String value : values) {
            if (value.isEmpty()) continue;
            int slash3 = this.getLastSlashFrom(value, value.length() - 1);
            int slash2 = this.getLastSlashFrom(value, slash3 - 1);
            int slash1 = this.getLastSlashFrom(value, slash2 - 1);
            if (slash1 == -1 || slash2 == -1 || slash3 == -1) {
                logger.warn("NER: Slash not found: '" + value + "'");
                continue;
            }
            String tag = value.substring(slash1 + 1, slash2);
            int fromPos = Integer.parseInt(value.substring(slash2 + 1, slash3));
            int toPos = Integer.parseInt(value.substring(slash3 + 1));
            if (!tag.equals("PERSON")) continue;
            res.add(new Span(fromPos, toPos));
        }
        return res;
    }

    private int getLastSlashFrom(String s2, int startPos) {
        for (int i = startPos; i >= 0; --i) {
            char ch = s2.charAt(i);
            if (ch != '/') continue;
            return i;
        }
        return -1;
    }

    static {
        CircuitBreakerConfig config = CircuitBreakerConfig.custom().slowCallDurationThreshold(slowDurationThreshold).slowCallRateThreshold(80.0f).failureRateThreshold(50.0f).waitDurationInOpenState(waitDurationOpen).build();
        circuitBreaker = CircuitBreakers.registry().circuitBreaker(NERService.class.getName(), config);
    }

    public static class Span {
        private final int fromPos;
        private final int toPos;

        public Span(int fromPos, int toPos) {
            if (fromPos >= toPos) {
                throw new IllegalArgumentException("fromPos must be < toPos: fromPos: " + fromPos + ", toPos: " + toPos);
            }
            this.fromPos = fromPos;
            this.toPos = toPos;
        }

        public int getStart() {
            return this.fromPos;
        }

        public int getEnd() {
            return this.toPos;
        }

        public String toString() {
            return this.fromPos + "-" + this.toPos;
        }
    }
}

