/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.CheckResults;
import org.languagetool.DetectedLanguage;
import org.languagetool.ExtendedSentenceRange;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Premium;
import org.languagetool.Range;
import org.languagetool.SentenceRange;
import org.languagetool.Tag;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.tools.ConfidenceKey;
import org.languagetool.tools.ContextTools;

public class RuleMatchesAsJsonSerializer {
    private static final int API_VERSION = 1;
    private static final String STATUS = "";
    private static final String PREMIUM_HINT = "You might be missing errors only the Premium version can find. Contact us at support<at>languagetoolplus.com.";
    private static final String START_MARKER = "__languagetool_start_marker";
    private static final JsonFactory factory = new JsonFactory();
    private static final String SUGGESTION = "<suggestion>";
    private static final String SUGGESTION_END = "</suggestion>";
    private static final Pattern ANYTHING_SLASH_PATTERN = Pattern.compile(".*/");
    private final int compactMode;
    private final Language lang;
    private Map<ConfidenceKey, Float> confidenceMap;

    public RuleMatchesAsJsonSerializer() {
        this(0, null);
    }

    public RuleMatchesAsJsonSerializer(int compactMode) {
        this(compactMode, null);
    }

    public RuleMatchesAsJsonSerializer(int compactMode, Language lang) {
        this.compactMode = compactMode;
        this.lang = lang;
    }

    public String ruleMatchesToJson(List<RuleMatch> matches, String text, int contextSize, DetectedLanguage detectedLang) {
        return this.ruleMatchesToJson(matches, new ArrayList<RuleMatch>(), text, contextSize, detectedLang, null);
    }

    public String ruleMatchesToJson(List<RuleMatch> matches, List<RuleMatch> hiddenMatches, String text, int contextSize, DetectedLanguage detectedLang, String incompleteResultsReason) {
        return this.ruleMatchesToJson(matches, hiddenMatches, new AnnotatedTextBuilder().addText(text).build(), contextSize, detectedLang, incompleteResultsReason, false);
    }

    public String ruleMatchesToJson(List<RuleMatch> matches, List<RuleMatch> hiddenMatches, AnnotatedText text, int contextSize, DetectedLanguage detectedLang, String incompleteResultsReason, boolean showPremiumHint) {
        return this.ruleMatchesToJson2(Collections.singletonList(new CheckResults(matches, Collections.emptyList())), hiddenMatches, text, contextSize, detectedLang, incompleteResultsReason, showPremiumHint, null);
    }

    public String ruleMatchesToJson2(List<CheckResults> res, List<RuleMatch> hiddenMatches, AnnotatedText text, int contextSize, DetectedLanguage detectedLang, String incompleteResultsReason, boolean showPremiumHint, JLanguageTool.Mode mode) {
        ContextTools contextTools = new ContextTools();
        contextTools.setEscapeHtml(false);
        contextTools.setContextSize(contextSize);
        contextTools.setErrorMarker(START_MARKER, STATUS);
        StringWriter sw = new StringWriter();
        try (JsonGenerator g2 = factory.createGenerator(sw);){
            g2.writeStartObject();
            this.writeSoftwareSection(g2, showPremiumHint);
            this.writeWarningsSection(g2, incompleteResultsReason);
            this.writeLanguageSection(g2, detectedLang);
            this.writeMatchesSection("matches", g2, res, text, contextTools);
            if (hiddenMatches != null && hiddenMatches.size() > 0) {
                this.writeMatchesSection("hiddenMatches", g2, Collections.singletonList(new CheckResults(hiddenMatches, Collections.emptyList())), text, contextTools);
            }
            this.writeIgnoreRanges(g2, res);
            this.writeSentenceRanges(g2, res);
            this.writeExtendedSentenceRanges(g2, res);
            g2.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    private void writeSoftwareSection(JsonGenerator g2, boolean showPremiumHint) throws IOException {
        if (this.compactMode == 1) {
            return;
        }
        g2.writeObjectFieldStart("software");
        g2.writeStringField("name", "LanguageTool");
        g2.writeStringField("version", JLanguageTool.VERSION);
        g2.writeStringField("buildDate", JLanguageTool.BUILD_DATE);
        g2.writeNumberField("apiVersion", 1);
        g2.writeBooleanField("premium", Premium.isPremiumVersion());
        if (showPremiumHint) {
            g2.writeStringField("premiumHint", PREMIUM_HINT);
        }
        g2.writeStringField("status", STATUS);
        g2.writeEndObject();
    }

    private void writeWarningsSection(JsonGenerator g2, String incompleteResultsReason) throws IOException {
        if (this.compactMode == 1 && incompleteResultsReason == null) {
            return;
        }
        g2.writeObjectFieldStart("warnings");
        if (incompleteResultsReason != null) {
            g2.writeBooleanField("incompleteResults", true);
            g2.writeStringField("incompleteResultsReason", incompleteResultsReason);
        } else {
            g2.writeBooleanField("incompleteResults", false);
        }
        g2.writeEndObject();
    }

    private void writeLanguageSection(JsonGenerator g2, DetectedLanguage detectedLang) throws IOException {
        g2.writeObjectFieldStart("language");
        g2.writeStringField("name", detectedLang.getGivenLanguage().getName());
        g2.writeStringField("code", detectedLang.getGivenLanguage().getShortCodeWithCountryAndVariant());
        if (detectedLang.getGivenLanguage().isSpellcheckOnlyLanguage()) {
            g2.writeBooleanField("spellCheckOnly", true);
        }
        g2.writeObjectFieldStart("detectedLanguage");
        g2.writeStringField("name", detectedLang.getDetectedLanguage().getName());
        g2.writeStringField("code", detectedLang.getDetectedLanguage().getShortCodeWithCountryAndVariant());
        g2.writeNumberField("confidence", detectedLang.getDetectionConfidence());
        if (detectedLang.getDetectedLanguage().isSpellcheckOnlyLanguage()) {
            g2.writeBooleanField("spellCheckOnly", true);
        }
        g2.writeStringField("source", detectedLang.getDetectionSource());
        g2.writeEndObject();
        g2.writeEndObject();
    }

    private void writeMatchesSection(String sectionName, JsonGenerator g2, List<CheckResults> res, AnnotatedText text, ContextTools contextTools) throws IOException {
        g2.writeArrayFieldStart(sectionName);
        for (CheckResults r : res) {
            for (RuleMatch match : r.getRuleMatches()) {
                g2.writeStartObject();
                g2.writeStringField("message", this.cleanSuggestion(match.getMessage()));
                if (match.getShortMessage() != null) {
                    g2.writeStringField("shortMessage", this.cleanSuggestion(match.getShortMessage()));
                }
                this.writeReplacements(g2, match);
                g2.writeNumberField("offset", match.getFromPos());
                g2.writeNumberField("length", match.getToPos() - match.getFromPos());
                this.writeContext(g2, match, text, contextTools);
                g2.writeObjectFieldStart("type");
                g2.writeStringField("typeName", match.getType().toString());
                g2.writeEndObject();
                this.writeRule(g2, match);
                int contextEstimate = match.getRule().estimateContextForSureMatch();
                g2.writeBooleanField("ignoreForIncompleteSentence", contextEstimate == -1 || contextEstimate > 3);
                g2.writeNumberField("contextForSureMatch", contextEstimate);
                g2.writeEndObject();
            }
        }
        g2.writeEndArray();
    }

    private void writeIgnoreRanges(JsonGenerator g2, List<CheckResults> res) throws IOException {
        if (res.stream().allMatch(k -> k.getIgnoredRanges().size() == 0)) {
            return;
        }
        g2.writeArrayFieldStart("ignoreRanges");
        for (CheckResults r : res) {
            for (Range range : r.getIgnoredRanges()) {
                g2.writeStartObject();
                g2.writeNumberField("from", range.getFromPos());
                g2.writeNumberField("to", range.getToPos());
                g2.writeObjectFieldStart("language");
                g2.writeStringField("code", range.getLang());
                g2.writeEndObject();
                g2.writeEndObject();
            }
        }
        g2.writeEndArray();
    }

    private void writeSentenceRanges(JsonGenerator g2, List<CheckResults> res) throws IOException {
        g2.writeArrayFieldStart("sentenceRanges");
        for (CheckResults r : res) {
            for (SentenceRange range : r.getSentenceRanges()) {
                g2.writeStartArray();
                g2.writeNumber(range.getFromPos());
                g2.writeNumber(range.getToPos());
                g2.writeEndArray();
            }
        }
        g2.writeEndArray();
    }

    private void writeExtendedSentenceRanges(JsonGenerator g2, List<CheckResults> res) throws IOException {
        g2.writeArrayFieldStart("extendedSentenceRanges");
        for (CheckResults r : res) {
            for (ExtendedSentenceRange range : r.getExtendedSentenceRanges()) {
                g2.writeStartObject();
                g2.writeNumberField("from", range.getFromPos());
                g2.writeNumberField("to", range.getToPos());
                g2.writeArrayFieldStart("detectedLanguages");
                for (Map.Entry<String, Float> entry : range.getLanguageConfidenceRates().entrySet()) {
                    String language = entry.getKey();
                    Float rate = entry.getValue();
                    g2.writeStartObject();
                    g2.writeStringField("language", language);
                    g2.writeNumberField("rate", rate.floatValue());
                    g2.writeEndObject();
                }
                g2.writeEndArray();
                g2.writeEndObject();
            }
        }
        g2.writeEndArray();
    }

    private String cleanSuggestion(String s2) {
        if (this.lang != null) {
            return this.lang.toAdvancedTypography(s2);
        }
        return s2.replace(SUGGESTION, "\"").replace(SUGGESTION_END, "\"");
    }

    private void writeReplacements(JsonGenerator g2, RuleMatch match) throws IOException {
        g2.writeArrayFieldStart("replacements");
        boolean autoCorrect = match.isAutoCorrect();
        int i = 0;
        for (SuggestedReplacement replacement : match.getSuggestedReplacementObjects()) {
            if (this.compactMode == 1 && ++i > 5) break;
            g2.writeStartObject();
            g2.writeStringField("value", replacement.getReplacement());
            if (replacement.getShortDescription() != null) {
                g2.writeStringField("shortDescription", replacement.getShortDescription());
            }
            if (replacement.getSuffix() != null) {
                g2.writeStringField("suffix", replacement.getSuffix());
            }
            if (replacement.getType() != SuggestedReplacement.SuggestionType.Default) {
                g2.writeStringField("type", replacement.getType().name());
            }
            if (autoCorrect) {
                g2.writeBooleanField("autoCorrect", true);
                autoCorrect = false;
            }
            if (replacement.getConfidence() != null) {
                g2.writeNumberField("confidence", replacement.getConfidence().floatValue());
            }
            g2.writeEndObject();
        }
        g2.writeEndArray();
    }

    private void writeContext(JsonGenerator g2, RuleMatch match, AnnotatedText text, ContextTools contextTools) throws IOException {
        if (this.compactMode != 1) {
            String context = contextTools.getContext(match.getFromPos(), match.getToPos(), text.getTextWithMarkup());
            int contextOffset = context.indexOf(START_MARKER);
            context = StringUtils.replaceOnce(context, START_MARKER, STATUS);
            g2.writeObjectFieldStart("context");
            g2.writeStringField("text", context);
            g2.writeNumberField("offset", contextOffset);
            g2.writeNumberField("length", match.getToPos() - match.getFromPos());
            g2.writeEndObject();
            if (match.getSentence() != null) {
                g2.writeStringField("sentence", match.getSentence().getText().trim());
            }
        }
    }

    private void writeRule(JsonGenerator g2, RuleMatch match) throws IOException {
        Float confidence;
        g2.writeObjectFieldStart("rule");
        Rule rule = match.getRule();
        g2.writeStringField("id", match.getSpecificRuleId());
        if (rule.getSubId() != null) {
            g2.writeStringField("subId", rule.getSubId());
        }
        if (rule.getSourceFile() != null && this.compactMode != 1) {
            g2.writeStringField("sourceFile", ANYTHING_SLASH_PATTERN.matcher(rule.getSourceFile()).replaceFirst(STATUS));
        }
        g2.writeStringField("description", rule.getDescription());
        g2.writeStringField("issueType", rule.getLocQualityIssueType().toString());
        if (rule.isDefaultTempOff()) {
            g2.writeBooleanField("tempOff", true);
        }
        if (match.getUrl() != null || rule.getUrl() != null) {
            g2.writeArrayFieldStart("urls");
            g2.writeStartObject();
            if (match.getUrl() != null) {
                g2.writeStringField("value", match.getUrl().toString());
            } else if (rule.getUrl() != null) {
                g2.writeStringField("value", rule.getUrl().toString());
            }
            g2.writeEndObject();
            g2.writeEndArray();
        }
        this.writeCategory(g2, rule.getCategory());
        if (Premium.isPremiumVersion()) {
            g2.writeBooleanField("isPremium", Premium.get().isPremiumRule(rule));
        }
        if (rule.getTags().size() > 0) {
            g2.writeArrayFieldStart("tags");
            for (Tag tag : rule.getTags()) {
                g2.writeString(tag.name());
            }
            g2.writeEndArray();
        }
        if (this.confidenceMap != null && (confidence = this.confidenceMap.get(new ConfidenceKey(this.lang, rule.getId()))) != null) {
            g2.writeNumberField("confidence", confidence.floatValue());
        }
        g2.writeEndObject();
    }

    private void writeCategory(JsonGenerator g2, Category category) throws IOException {
        g2.writeObjectFieldStart("category");
        CategoryId catId = category.getId();
        g2.writeStringField("id", catId.toString());
        g2.writeStringField("name", category.getName());
        g2.writeEndObject();
    }

    public void setRuleIdToConfidenceMap(Map<ConfidenceKey, Float> confidenceMap) {
        this.confidenceMap = confidenceMap;
    }
}

