/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya;

import java.math.BigDecimal;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import tec.uom.lib.common.function.UnitSupplier;
import tec.uom.lib.common.function.ValueSupplier;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.NaturalQuantityComparator;
import tech.units.indriya.quantity.Quantities;

public abstract class AbstractQuantity<Q extends Quantity<Q>>
implements ComparableQuantity<Q>,
UnitSupplier<Q>,
ValueSupplier<Number> {
    private static final long serialVersionUID = 293852425369811882L;
    private final Unit<Q> unit;
    public static final Quantity<Dimensionless> NONE = Quantities.getQuantity(0, AbstractUnit.ONE);
    public static final Quantity<Dimensionless> ONE = Quantities.getQuantity(1, AbstractUnit.ONE);

    protected AbstractQuantity(Unit<Q> unit) {
        this.unit = unit;
    }

    @Override
    public abstract Number getValue();

    @Override
    public Unit<Q> getUnit() {
        return this.unit;
    }

    @Override
    public ComparableQuantity<Q> to(Unit<Q> unit) {
        if (unit.equals(this.getUnit())) {
            return this;
        }
        UnitConverter t2 = this.getUnit().getConverterTo(unit);
        Number convertedValue = t2.convert(this.getValue());
        return Quantities.getQuantity(convertedValue, unit);
    }

    @Override
    public boolean isGreaterThan(Quantity<Q> that) {
        return this.compareTo(that) > 0;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Quantity<Q> that) {
        return this.compareTo(that) >= 0;
    }

    @Override
    public boolean isLessThan(Quantity<Q> that) {
        return this.compareTo(that) < 0;
    }

    @Override
    public boolean isLessThanOrEqualTo(Quantity<Q> that) {
        return this.compareTo(that) <= 0;
    }

    @Override
    public boolean isEquivalentOf(Quantity<Q> that) {
        return this.compareTo(that) == 0;
    }

    @Override
    public int compareTo(Quantity<Q> that) {
        NaturalQuantityComparator<Quantity<Q>> comparator = new NaturalQuantityComparator<Quantity<Q>>();
        return comparator.compare((Quantity<Q>)this, that);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractQuantity) {
            AbstractQuantity that = (AbstractQuantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    public boolean equals(AbstractQuantity<Q> that, double epsilon, Unit<Q> epsilonUnit) {
        return Math.abs(this.doubleValue(epsilonUnit) - that.doubleValue(epsilonUnit)) <= epsilon;
    }

    public int hashCode() {
        return Objects.hash(this.getUnit(), this.getValue());
    }

    public abstract boolean isBig();

    public String toString() {
        return String.valueOf(this.getValue()) + " " + String.valueOf(this.getUnit());
    }

    public abstract BigDecimal decimalValue(Unit<Q> var1) throws ArithmeticException;

    public abstract double doubleValue(Unit<Q> var1) throws ArithmeticException;

    public final int intValue(Unit<Q> unit) throws ArithmeticException {
        long longValue = this.longValue(unit);
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Cannot convert " + longValue + " to int (overflow)");
        }
        return (int)longValue;
    }

    protected long longValue(Unit<Q> unit) throws ArithmeticException {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    protected final float floatValue(Unit<Q> unit) {
        return (float)this.doubleValue(unit);
    }

    @Override
    public <T extends Quantity<T>, E extends Quantity<E>> ComparableQuantity<E> divide(Quantity<T> that, Class<E> asTypeQuantity) {
        return this.divide((Quantity)Objects.requireNonNull(that)).asType((Class)Objects.requireNonNull(asTypeQuantity));
    }

    @Override
    public <T extends Quantity<T>, E extends Quantity<E>> ComparableQuantity<E> multiply(Quantity<T> that, Class<E> asTypeQuantity) {
        return this.multiply((Quantity)Objects.requireNonNull(that)).asType((Class)Objects.requireNonNull(asTypeQuantity));
    }

    @Override
    public <T extends Quantity<T>> ComparableQuantity<T> inverse(Class<T> quantityClass) {
        return this.inverse().asType((Class)quantityClass);
    }

    @Override
    public final <T extends Quantity<T>> ComparableQuantity<T> asType(Class<T> type) throws ClassCastException {
        this.getUnit().asType(type);
        return this;
    }

    public static Quantity<?> parse(CharSequence csq) {
        return SimpleQuantityFormat.getInstance().parse(csq);
    }

    protected boolean hasFraction(double value) {
        return (double)Math.round(value) != value;
    }

    protected boolean hasFraction(BigDecimal value) {
        return value.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0;
    }

    protected static final class Equalizer {
        protected Equalizer() {
        }

        public static boolean hasEquality(Number valueA, Number valueB) {
            Objects.requireNonNull(valueA);
            Objects.requireNonNull(valueB);
            if (valueA instanceof Double && valueB instanceof Double) {
                return valueA.doubleValue() == valueB.doubleValue();
            }
            if (valueA instanceof Float && valueB instanceof Float) {
                return valueA.floatValue() == valueB.floatValue();
            }
            if (valueA instanceof Integer && valueB instanceof Integer) {
                return valueA.intValue() == valueB.intValue();
            }
            if (valueA instanceof Long && valueB instanceof Long) {
                return valueA.longValue() == valueB.longValue();
            }
            if (valueA instanceof Short && valueB instanceof Short) {
                return valueA.shortValue() == valueB.shortValue();
            }
            if (valueA instanceof Byte && valueB instanceof Byte) {
                return valueA.byteValue() == valueB.byteValue();
            }
            return Calculus.toBigDecimal(valueA).compareTo(Calculus.toBigDecimal(valueB)) == 0;
        }
    }
}

